/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.LtrNetMessage;
import java.util.function.Function;

public class LTRNetMessageFilter
extends Filter<IMessage, LtrNetMessageType> {
    private final KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public LTRNetMessageFilter() {
        super("LTR-Net Messages");
        for (LtrNetMessageType type : LtrNetMessageType.values()) {
            this.add(new FilterElement<LtrNetMessageType>(type));
        }
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof LtrNetMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, LtrNetMessageType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, LtrNetMessageType> {
        private KeyExtractor(LTRNetMessageFilter lTRNetMessageFilter) {
        }

        @Override
        public LtrNetMessageType apply(IMessage message) {
            if (message instanceof LtrNetMessage) {
                LtrNetMessage ltr = (LtrNetMessage)message;
                return ltr.getLtrNetMessageType();
            }
            return null;
        }
    }
}

