/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.identifier.esn.ESNIdentifier;
import io.github.dsheirer.identifier.talkgroup.LTRTalkgroup;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.ltrnet.LTRNetDecodeEvent;
import io.github.dsheirer.module.decode.ltrnet.channel.LtrNetChannel;
import io.github.dsheirer.module.decode.ltrnet.identifier.LtrNetRadioIdentifier;
import io.github.dsheirer.module.decode.ltrnet.message.LtrNetMessage;
import io.github.dsheirer.module.decode.ltrnet.message.isw.IswCallEnd;
import io.github.dsheirer.module.decode.ltrnet.message.isw.IswCallStart;
import io.github.dsheirer.module.decode.ltrnet.message.isw.IswUniqueId;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RegistrationRequestEsnHigh;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RegistrationRequestEsnLow;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RequestAccess;
import io.github.dsheirer.module.decode.ltrnet.message.osw.ChannelMapHigh;
import io.github.dsheirer.module.decode.ltrnet.message.osw.ChannelMapLow;
import io.github.dsheirer.module.decode.ltrnet.message.osw.NeighborId;
import io.github.dsheirer.module.decode.ltrnet.message.osw.OswCallEnd;
import io.github.dsheirer.module.decode.ltrnet.message.osw.OswCallStart;
import io.github.dsheirer.module.decode.ltrnet.message.osw.ReceiveFrequencyHigh;
import io.github.dsheirer.module.decode.ltrnet.message.osw.ReceiveFrequencyLow;
import io.github.dsheirer.module.decode.ltrnet.message.osw.RegistrationAccept;
import io.github.dsheirer.module.decode.ltrnet.message.osw.SiteId;
import io.github.dsheirer.module.decode.ltrnet.message.osw.SystemIdle;
import io.github.dsheirer.module.decode.ltrnet.message.osw.TransmitFrequencyHigh;
import io.github.dsheirer.module.decode.ltrnet.message.osw.TransmitFrequencyLow;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRNetDecoderState
extends DecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(LTRNetDecoderState.class);
    private ChannelMapHigh mChannelMapHigh;
    private ChannelMapLow mChannelMapLow;
    private Map<Integer, LtrNetChannel> mChannelMap = new HashMap<Integer, LtrNetChannel>();
    private Map<Integer, DecodeEvent> mCallDetectMap = new HashMap<Integer, DecodeEvent>();
    private Map<Integer, NeighborId> mNeighborMap = new HashMap<Integer, NeighborId>();
    private SiteId mCurrentSite;
    private int mCurrentChannelNumber;
    private Set<LTRTalkgroup> mTalkgroups = new TreeSet<LTRTalkgroup>();
    private Set<LtrNetRadioIdentifier> mLtrNetRadioIdentifiers = new TreeSet<LtrNetRadioIdentifier>();
    private Set<ESNIdentifier> mESNIdentifiers = new TreeSet<ESNIdentifier>();
    private DecodeEvent mCurrentCallEvent;
    private LTRTalkgroup mCurrentCallTalkgroup;

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LTR_NET;
    }

    @Override
    protected IChannelDescriptor getCurrentChannel() {
        if (this.mCurrentChannelNumber > 0) {
            return this.mChannelMap.get(this.mCurrentChannelNumber);
        }
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this.mChannelMapHigh = null;
        this.mChannelMapLow = null;
        this.mChannelMap.clear();
        this.mCallDetectMap.clear();
        this.mNeighborMap.clear();
        this.mCurrentSite = null;
        this.mCurrentChannelNumber = 0;
        this.mTalkgroups.clear();
        this.mLtrNetRadioIdentifiers.clear();
        this.mESNIdentifiers.clear();
        this.resetState();
    }

    private void processCallEnd(int channel, LTRTalkgroup talkgroup, long timestamp) {
        this.setCurrentChannelNumber(channel);
        if (this.mCurrentCallTalkgroup != null && this.mCurrentCallTalkgroup.equals(talkgroup)) {
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
            this.mCurrentCallEvent = null;
            this.mCurrentCallTalkgroup = null;
            this.getIdentifierCollection().remove(IdentifierClass.USER);
        }
        if (talkgroup.getTalkgroup() == 254) {
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
        } else {
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.END, State.CALL));
        }
    }

    private void processCallStart(int channel, LTRTalkgroup talkgroup, long timestamp, MessageDirection direction) {
        if (direction == MessageDirection.ISW) {
            this.setCurrentChannelNumber(channel);
        }
        if (channel == this.mCurrentChannelNumber || this.mCurrentChannelNumber == 0) {
            this.setCurrentChannelNumber(channel);
            if (this.mCurrentCallTalkgroup == null || !this.mCurrentCallTalkgroup.equals(talkgroup)) {
                DecodeEventType decodeEventType = null;
                decodeEventType = talkgroup.getTalkgroup() == 253 ? DecodeEventType.REGISTER : (talkgroup.getTalkgroup() == 254 ? DecodeEventType.STATION_ID : DecodeEventType.CALL);
                this.getIdentifierCollection().remove(IdentifierClass.USER);
                this.getIdentifierCollection().update(talkgroup);
                this.mCurrentCallEvent = LTRNetDecodeEvent.builder(decodeEventType, timestamp).channel(this.getCurrentChannel()).identifiers(this.getIdentifierCollection().copyOf()).build();
                this.mCurrentCallTalkgroup = talkgroup;
            }
            this.mCurrentCallEvent.update(timestamp);
            if (talkgroup.getTalkgroup() == 253) {
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.DATA));
            } else if (talkgroup.getTalkgroup() == 254) {
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.DATA));
            } else {
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CALL));
            }
            this.broadcast(this.mCurrentCallEvent);
        } else {
            DecodeEvent decodeEvent = this.mCallDetectMap.get(channel);
            if (decodeEvent == null) {
                decodeEvent = this.getDecodeEvent(talkgroup, channel, timestamp, DecodeEventType.CALL_DETECT);
                this.mCallDetectMap.put(channel, decodeEvent);
            } else {
                Identifier eventTalkgroup = decodeEvent.getIdentifierCollection().getIdentifier(IdentifierClass.USER, Form.TALKGROUP, Role.TO);
                if (eventTalkgroup == null || !eventTalkgroup.equals(talkgroup) || timestamp - decodeEvent.getTimeStart() - decodeEvent.getDuration() > 2000L) {
                    decodeEvent = this.getDecodeEvent(talkgroup, channel, timestamp, DecodeEventType.CALL_DETECT);
                    this.mCallDetectMap.put(channel, decodeEvent);
                }
            }
            decodeEvent.update(timestamp);
            this.broadcast(decodeEvent);
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
        }
    }

    private void updateCurrentCallIdentifiers() {
        if (this.mCurrentCallEvent != null) {
            this.mCurrentCallEvent.setIdentifierCollection(this.getIdentifierCollection().copyOf());
            this.broadcast(this.mCurrentCallEvent);
        }
    }

    private void updateReceiveFrequency(int channel, long frequency) {
        if (0 < channel && channel <= 20 && frequency > 0L) {
            LtrNetChannel ltrNetChannel = this.mChannelMap.get(channel);
            if (ltrNetChannel == null) {
                ltrNetChannel = new LtrNetChannel(channel);
                ltrNetChannel.setUplink(frequency);
                this.mChannelMap.put(channel, ltrNetChannel);
            } else {
                ltrNetChannel.setUplink(frequency);
            }
        }
    }

    private void updateTransmitFrequency(int channel, long frequency) {
        if (0 < channel && channel <= 20 && frequency > 0L) {
            LtrNetChannel ltrNetChannel = this.mChannelMap.get(channel);
            if (ltrNetChannel == null) {
                ltrNetChannel = new LtrNetChannel(channel);
                ltrNetChannel.setDownlink(frequency);
                this.mChannelMap.put(channel, ltrNetChannel);
            } else {
                ltrNetChannel.setDownlink(frequency);
            }
        }
    }

    @Override
    public void receive(IMessage message) {
        if (message.isValid() && message instanceof LtrNetMessage) {
            switch (((LtrNetMessage)message).getLtrNetMessageType()) {
                case ISW_CALL_END: {
                    if (!(message instanceof IswCallEnd)) break;
                    IswCallEnd callEnd = (IswCallEnd)message;
                    this.mTalkgroups.add(callEnd.getTalkgroup());
                    this.processCallEnd(callEnd.getChannel(), callEnd.getTalkgroup(), callEnd.getTimestamp());
                    break;
                }
                case ISW_CALL_START: {
                    if (!(message instanceof IswCallStart)) break;
                    IswCallStart callStart = (IswCallStart)message;
                    this.mTalkgroups.add(callStart.getTalkgroup());
                    this.processCallStart(callStart.getChannel(), callStart.getTalkgroup(), callStart.getTimestamp(), MessageDirection.ISW);
                    break;
                }
                case ISW_REGISTRATION_REQUEST_ESN_HIGH: {
                    if (!(message instanceof RegistrationRequestEsnHigh)) break;
                    RegistrationRequestEsnHigh registrationRequestEsn = (RegistrationRequestEsnHigh)message;
                    if (registrationRequestEsn.isCompleteEsn()) {
                        this.getIdentifierCollection().update(registrationRequestEsn.getESN());
                        this.mESNIdentifiers.add(registrationRequestEsn.getESN());
                    }
                    this.broadcast(this.getDecodeEvent(message, DecodeEventType.REQUEST, "REGISTER: " + String.valueOf(registrationRequestEsn)));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.DATA));
                    break;
                }
                case ISW_REGISTRATION_REQUEST_ESN_LOW: {
                    if (!(message instanceof RegistrationRequestEsnLow)) break;
                    RegistrationRequestEsnLow registrationRequestEsn = (RegistrationRequestEsnLow)message;
                    if (registrationRequestEsn.isCompleteEsn()) {
                        this.getIdentifierCollection().update(registrationRequestEsn.getESN());
                        this.mESNIdentifiers.add(registrationRequestEsn.getESN());
                    }
                    this.broadcast(this.getDecodeEvent(message, DecodeEventType.REQUEST, "REGISTER: " + String.valueOf(registrationRequestEsn)));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.DATA));
                    break;
                }
                case ISW_REQUEST_ACCESS: {
                    if (!(message instanceof RequestAccess)) break;
                    RequestAccess requestAccess = (RequestAccess)message;
                    this.getIdentifierCollection().update(requestAccess.getTalkgroup());
                    this.mTalkgroups.add(requestAccess.getTalkgroup());
                    this.broadcast(this.getDecodeEvent(message, DecodeEventType.REQUEST, "ACCESS: " + String.valueOf(requestAccess)));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.DATA));
                    break;
                }
                case ISW_UNIQUE_ID: {
                    if (!(message instanceof IswUniqueId)) break;
                    IswUniqueId iswUniqueId = (IswUniqueId)message;
                    this.getIdentifierCollection().update(iswUniqueId.getUniqueID());
                    this.mLtrNetRadioIdentifiers.add(iswUniqueId.getUniqueID());
                    this.updateCurrentCallIdentifiers();
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.DATA));
                    break;
                }
                case ISW_UNKNOWN: {
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_CALL_END: {
                    if (!(message instanceof OswCallEnd)) break;
                    OswCallEnd callEnd = (OswCallEnd)message;
                    this.mTalkgroups.add(callEnd.getTalkgroup());
                    this.processCallEnd(callEnd.getChannel(), callEnd.getTalkgroup(), callEnd.getTimestamp());
                    break;
                }
                case OSW_CALL_START: {
                    if (!(message instanceof OswCallStart)) break;
                    OswCallStart callStart = (OswCallStart)message;
                    this.mTalkgroups.add(callStart.getTalkgroup());
                    this.processCallStart(callStart.getChannel(), callStart.getTalkgroup(), callStart.getTimestamp(), MessageDirection.OSW);
                    break;
                }
                case OSW_CHANNEL_MAP_HIGH: {
                    if (message instanceof ChannelMapHigh) {
                        ChannelMapHigh channelMapHigh;
                        this.mChannelMapHigh = channelMapHigh = (ChannelMapHigh)message;
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_CHANNEL_MAP_LOW: {
                    if (message instanceof ChannelMapLow) {
                        ChannelMapLow channelMapLow;
                        this.mChannelMapLow = channelMapLow = (ChannelMapLow)message;
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_SYSTEM_IDLE: {
                    if (message instanceof SystemIdle) {
                        SystemIdle systemIdle = (SystemIdle)message;
                        this.setCurrentChannelNumber(systemIdle.getChannel());
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_NEIGHBOR_ID: {
                    if (message instanceof NeighborId) {
                        NeighborId neighborId = (NeighborId)message;
                        this.mNeighborMap.put(neighborId.getNeighborRank(), neighborId);
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_RECEIVE_FREQUENCY_HIGH: {
                    if (message instanceof ReceiveFrequencyHigh) {
                        ReceiveFrequencyHigh receiveFrequency = (ReceiveFrequencyHigh)message;
                        this.updateReceiveFrequency(receiveFrequency.getChannel(), receiveFrequency.getFrequency());
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_RECEIVE_FREQUENCY_LOW: {
                    if (message instanceof ReceiveFrequencyLow) {
                        ReceiveFrequencyLow receiveFrequency = (ReceiveFrequencyLow)message;
                        this.updateReceiveFrequency(receiveFrequency.getChannel(), receiveFrequency.getFrequency());
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_REGISTRATION_ACCEPT: {
                    if (!(message instanceof RegistrationAccept)) break;
                    RegistrationAccept registrationAccept = (RegistrationAccept)message;
                    this.mLtrNetRadioIdentifiers.add(registrationAccept.getUniqueID());
                    MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                    ic.remove(IdentifierClass.USER);
                    ic.update(message.getIdentifiers());
                    this.broadcast(this.getDecodeEvent(message, DecodeEventType.RESPONSE, "REGISTRATION ACCEPT: " + String.valueOf(registrationAccept)));
                    break;
                }
                case OSW_SITE_ID: {
                    if (message instanceof SiteId) {
                        SiteId siteId;
                        this.mCurrentSite = siteId = (SiteId)message;
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_TRANSMIT_FREQUENCY_HIGH: {
                    if (message instanceof TransmitFrequencyHigh) {
                        TransmitFrequencyHigh transmitFrequency = (TransmitFrequencyHigh)message;
                        this.updateTransmitFrequency(transmitFrequency.getChannel(), transmitFrequency.getFrequency());
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_TRANSMIT_FREQUENCY_LOW: {
                    if (message instanceof TransmitFrequencyLow) {
                        TransmitFrequencyLow transmitFrequency = (TransmitFrequencyLow)message;
                        this.updateTransmitFrequency(transmitFrequency.getChannel(), transmitFrequency.getFrequency());
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                    break;
                }
                case OSW_UNKNOWN: {
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.IDLE));
                }
            }
        }
    }

    private DecodeEvent getDecodeEvent(IMessage message, DecodeEventType decodeEventType, String details) {
        return LTRNetDecodeEvent.builder(decodeEventType, message.getTimestamp()).details(details).identifiers(this.getIdentifierCollection().copyOf()).channel(this.getCurrentChannel()).build();
    }

    private DecodeEvent getDecodeEvent(LTRTalkgroup talkgroup, int channel, long timestamp, DecodeEventType decodeEventType) {
        MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
        ic.remove(IdentifierClass.USER);
        ic.update(talkgroup);
        return LTRNetDecodeEvent.builder(decodeEventType, timestamp).channel(this.mChannelMap.get(channel)).identifiers(ic).build();
    }

    @Override
    public String getActivitySummary() {
        LtrNetChannel ltrNetChannel;
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary\n");
        sb.append("Decoder:\tLTR-Net\n\n");
        sb.append("Site:\t").append(this.mCurrentSite != null ? this.mCurrentSite.getSiteID() : "Unknown").append("\n");
        sb.append("\nLCNs (transmit / receive)\n");
        if (this.mChannelMapLow != null) {
            for (int channel : this.mChannelMapLow.getChannels()) {
                ltrNetChannel = this.mChannelMap.get(channel);
                sb.append("  ").append(channel).append(": ").append(ltrNetChannel != null ? ltrNetChannel.description() : "Unknown").append(this.mCurrentChannelNumber == channel ? " (Current)\n" : "\n");
            }
        } else {
            sb.append("Channel Map 1-10: Unknown\n");
        }
        if (this.mChannelMapHigh != null) {
            for (int channel : this.mChannelMapHigh.getChannels()) {
                ltrNetChannel = this.mChannelMap.get(channel);
                sb.append("  ").append(channel).append(": ").append(ltrNetChannel != null ? ltrNetChannel.description() : "Unknown").append(this.mCurrentChannelNumber == channel ? " (Current)\n" : "\n");
            }
        } else {
            sb.append("Channel Map 11-20: Unknown\n");
        }
        sb.append("\nNeighbor Sites (Rank: ID)\n");
        if (this.mNeighborMap.isEmpty()) {
            sb.append("  None\n");
        } else {
            ArrayList<Integer> ranks = new ArrayList<Integer>(this.mNeighborMap.keySet());
            Collections.sort(ranks);
            for (Integer rank : ranks) {
                sb.append("  ").append(rank).append(": ").append(this.mNeighborMap.get(rank).getNeighborID()).append("\n");
            }
        }
        sb.append("\nActive Talkgroups\n");
        if (this.mTalkgroups.isEmpty()) {
            sb.append("  None\n");
        } else {
            ArrayList<LTRTalkgroup> talkgroups = new ArrayList<LTRTalkgroup>(this.mTalkgroups);
            talkgroups.sort(Comparator.comparingInt(Identifier::getValue));
            for (LTRTalkgroup talkgroup : talkgroups) {
                sb.append("  ").append(talkgroup.formatted()).append("\n");
            }
        }
        sb.append("\nActive Radio Unique IDs\n");
        if (this.mLtrNetRadioIdentifiers.isEmpty()) {
            sb.append("  None\n");
        } else {
            ArrayList<LtrNetRadioIdentifier> ltrNetRadioIdentifiers = new ArrayList<LtrNetRadioIdentifier>(this.mLtrNetRadioIdentifiers);
            ltrNetRadioIdentifiers.sort(Comparator.comparingInt(Identifier::getValue));
            for (LtrNetRadioIdentifier ltrNetRadioIdentifier : ltrNetRadioIdentifiers) {
                sb.append("  ").append(ltrNetRadioIdentifier).append("\n");
            }
        }
        sb.append("\nActive ESNs\n");
        if (this.mESNIdentifiers.isEmpty()) {
            sb.append("  None\n");
        } else {
            ArrayList<ESNIdentifier> esnIdentifiers = new ArrayList<ESNIdentifier>(this.mESNIdentifiers);
            Collections.sort(esnIdentifiers);
            for (ESNIdentifier esnIdentifier : esnIdentifiers) {
                sb.append("  ").append(esnIdentifier).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.mCurrentCallEvent = null;
        this.mCurrentCallTalkgroup = null;
    }

    public void setCurrentChannelNumber(int channelNumber) {
        if (0 < channelNumber && channelNumber <= 20) {
            this.mCurrentChannelNumber = channelNumber;
            LtrNetChannel currentChannel = this.mChannelMap.get(this.mCurrentChannelNumber);
            if (currentChannel != null) {
                this.getIdentifierCollection().update(DecoderLogicalChannelNameIdentifier.create(String.valueOf(this.mCurrentChannelNumber), Protocol.LTR_NET));
            }
        }
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                break;
            }
        }
    }
}

