/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.lj1200;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.lj1200.LJ1200Message;
import io.github.dsheirer.module.decode.lj1200.LJ1200TransponderMessage;
import io.github.dsheirer.sample.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LJ1200MessageProcessor
implements Listener<CorrectedBinaryMessage> {
    private static final Logger mLog = LoggerFactory.getLogger(LJ1200MessageProcessor.class);
    public static int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static int SYNC_TOWER = 21775;
    public static int SYNC_TRANSPONDER = 10965;
    private Listener<IMessage> mMessageListener;

    public void dispose() {
        this.mMessageListener = null;
    }

    @Override
    public void receive(CorrectedBinaryMessage message) {
        int sync = message.getInt(SYNC);
        if (sync == SYNC_TOWER) {
            if (this.mMessageListener != null) {
                this.mMessageListener.receive(new LJ1200Message(message));
            }
        } else if (sync == SYNC_TRANSPONDER && this.mMessageListener != null) {
            this.mMessageListener.receive(new LJ1200TransponderMessage(message));
        }
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }
}

