/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.udp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.udp.UDPPort;

public class UDPHeader
extends Header {
    private static final int[] SOURCE_PORT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] DESTINATION_PORT = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private UDPPort mSourcePort;
    private UDPPort mDestinationPort;

    public UDPHeader(BinaryMessage message, int offset) {
        super(message, offset);
        this.checkValid();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UDP PORT FROM:").append(this.getSourcePort());
        sb.append(" TO:").append(this.getDestinationPort());
        return sb.toString();
    }

    private void checkValid() {
        this.setValid(this.getMessage().size() >= this.getOffset() + this.getLength());
    }

    @Override
    public int getLength() {
        return 64;
    }

    public UDPPort getSourcePort() {
        if (this.mSourcePort == null) {
            this.mSourcePort = UDPPort.createFrom(this.getMessage().getInt(SOURCE_PORT, this.getOffset()));
        }
        return this.mSourcePort;
    }

    public UDPPort getDestinationPort() {
        if (this.mDestinationPort == null) {
            this.mDestinationPort = UDPPort.createTo(this.getMessage().getInt(DESTINATION_PORT, this.getOffset()));
        }
        return this.mDestinationPort;
    }
}

