/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import java.text.DecimalFormat;

public class Speed
extends Token {
    private static final int[] SPEED = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final double SPEED_MULTIPLIER = 0.01;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public Speed(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.SPEED;
    }

    public double getSpeed() {
        return (double)this.getMessage().getInt(SPEED, this.getOffset()) * 0.01;
    }

    public String toString() {
        return "SPEED:" + DECIMAL_FORMAT.format(this.getSpeed()) + " MPH";
    }
}

