/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.ResponseCode;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;

public class Response
extends Token {
    private static final int CODE_LENGTH_FLAG = 8;
    private static final int[] ONE_BYTE_CODE = new int[]{9, 10, 11, 12, 13, 14, 15};
    private static final int[] TWO_BYTE_CODE = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};

    public Response(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.RESPONSE;
    }

    private boolean isExtendedCode() {
        return this.getMessage().get(8);
    }

    public int getCodeValue() {
        if (this.isExtendedCode()) {
            return this.getMessage().getInt(TWO_BYTE_CODE, this.getOffset());
        }
        return this.getMessage().getInt(ONE_BYTE_CODE, this.getOffset());
    }

    public ResponseCode getResponseCode() {
        return ResponseCode.fromValue(this.getCodeValue());
    }

    @Override
    public int getByteLength() {
        return this.isExtendedCode() ? 3 : 2;
    }

    public String toString() {
        ResponseCode responseCode = this.getResponseCode();
        if (responseCode == ResponseCode.UNKNOWN) {
            return "RESPONSE: UNKNOWN[" + this.getCodeValue() + "]";
        }
        return "RESPONSE:" + String.valueOf((Object)responseCode);
    }
}

