/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import java.text.DecimalFormat;

public class Heading
extends Token {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("000.0");
    private static final int[] HEADING = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final float HEADING_MULTIPLIER = 2.0f;

    public Heading(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.HEADING;
    }

    public float getHeading() {
        return (float)this.getMessage().getInt(HEADING, this.getOffset()) * 2.0f;
    }

    public String toString() {
        return "HEADING:" + DECIMAL_FORMAT.format(this.getHeading());
    }
}

