/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Circle2d;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import java.text.DecimalFormat;

public class Circle3d
extends Circle2d {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final int[] ALTITUDE = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] ALTITUDE_ACCURACY = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119};

    public Circle3d(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.CIRCLE_3D;
    }

    public float getAltitude() {
        return (float)this.getMessage().getInt(ALTITUDE, this.getOffset()) * 0.01f;
    }

    public float getAltitudeAccuracy() {
        return (float)this.getMessage().getInt(ALTITUDE_ACCURACY, this.getOffset()) * 0.01f;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CIRCLE 3D POSITION:").append(this.getPosition());
        sb.append(" RADIUS:").append(DECIMAL_FORMAT.format(this.getRadius()));
        sb.append("MTRS ALTITUDE:").append(DECIMAL_FORMAT.format(this.getAltitude()));
        sb.append(" ALT ACCURACY:").append(DECIMAL_FORMAT.format(this.getAltitudeAccuracy()));
        return sb.toString();
    }
}

