/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp;

public enum LRRPPacketType {
    IMMEDIATE_LOCATION_REQUEST(5, "IMMEDIATE LOCATION REQUEST", false),
    IMMEDIATE_LOCATION_RESPONSE(7, "IMMEDIATE LOCATION RESPONSE", true),
    TRIGGERED_LOCATION_START_REQUEST(9, "TRIGGERED LOCATION START REQUEST", false),
    TRIGGERED_LOCATION_START_RESPONSE(11, "TRIGGERED LOCATION START RESPONSE", true),
    TRIGGERED_LOCATION(13, "TRIGGERED LOCATION", true),
    TRIGGERED_LOCATION_STOP_REQUEST(15, "TRIGGERED LOCATION STOP REQUEST", false),
    TRIGGERED_LOCATION_STOP_RESPONSE(17, "TRIGGERED LOCATION STOP RESPONSE", true),
    PROTOCOL_VERSION_REQUEST(20, "PROTOCOL VERSION REQUEST", false),
    PROTOCOL_VERSION_RESPONSE(21, "PROTOCOL VERSION RESPONSE", true),
    UNKNOWN(-1, "UNKNOWN", false);

    private int mValue;
    private String mLabel;
    private boolean mIsResponse;

    private LRRPPacketType(int value, String label, boolean isResponse) {
        this.mValue = value;
        this.mLabel = label;
        this.mIsResponse = isResponse;
    }

    public int getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mLabel;
    }

    public boolean isResponse() {
        return this.mIsResponse;
    }

    public static LRRPPacketType fromValue(int value) {
        for (LRRPPacketType lrrpPacketType : LRRPPacketType.values()) {
            if (lrrpPacketType.getValue() != value) continue;
            return lrrpPacketType;
        }
        return UNKNOWN;
    }
}

