/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPHeader;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacketType;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.RequestedTokens;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenFactory;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LRRPPacket
extends Packet {
    private static final int[] BYTE_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int TOKEN_START = 16;
    private LRRPHeader mHeader;
    private List<Token> mTokens;

    public LRRPPacket(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LRRPPacketType type = this.getHeader().getLRRPPacketType();
        if (type == LRRPPacketType.UNKNOWN) {
            sb.append("LRRP TYPE:UNKNOWN [").append(this.getHeader().getLrrpPacketTypeValue()).append("]");
        } else {
            sb.append("LRRP ").append((Object)type);
        }
        for (Token token : this.getTokens()) {
            sb.append(" ").append(token);
        }
        return sb.toString();
    }

    @Override
    public LRRPHeader getHeader() {
        if (this.mHeader == null) {
            this.mHeader = new LRRPHeader(this.getMessage(), this.getOffset());
        }
        return this.mHeader;
    }

    public List<Token> getTokens() {
        this.parseTokens();
        return this.mTokens;
    }

    private boolean isResponsePacket() {
        return this.getHeader().getLRRPPacketType().isResponse();
    }

    private void parseTokens() {
        if (this.mTokens == null) {
            this.mTokens = new ArrayList<Token>();
            int characterCount = this.getHeader().getPayloadLength();
            if (this.isResponsePacket()) {
                Token token;
                for (offset = this.getOffset() + 16; characterCount > 0 && offset < this.getMessage().size(); characterCount -= token.getByteLength(), offset += 8 * token.getByteLength()) {
                    String tokenId = this.getTokenIdentifier(offset);
                    token = TokenFactory.createToken(tokenId, this.getMessage(), offset, characterCount);
                    this.mTokens.add(token);
                }
            } else {
                String message = this.getMessage().getSubMessage(this.getOffset(), this.getOffset() + (characterCount + 2) * 8).toHexString();
                boolean x = false;
                RequestedTokens requestedTokens = new RequestedTokens();
                while (characterCount > 0 && offset < this.getMessage().size()) {
                    String tokenId = this.getTokenIdentifier(offset);
                    TokenType tokenType = TokenType.fromValue(tokenId);
                    if (tokenType.isRequestParameterToken()) {
                        Token token = TokenFactory.createToken(tokenId, this.getMessage(), offset, characterCount);
                        this.mTokens.add(token);
                        characterCount -= token.getByteLength();
                        offset += 8 * token.getByteLength();
                        continue;
                    }
                    if (tokenType != TokenType.UNKNOWN) {
                        requestedTokens.add(tokenType);
                    } else {
                        requestedTokens.add(tokenId);
                    }
                    --characterCount;
                    offset += 8;
                }
                if (requestedTokens.hasRequestedTokens()) {
                    this.mTokens.add(requestedTokens);
                }
            }
            Collections.sort(this.mTokens, (o1, o2) -> o1.getTokenType().compareTo(o2.getTokenType()));
        }
    }

    private String getTokenIdentifier(int offset) {
        int id = this.getMessage().getInt(BYTE_VALUE, offset);
        return String.format("%02X", id);
    }

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getHeader().getIdentifiers();
    }
}

