/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.ars;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSHeader;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.identifier.ARSDevice;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.identifier.ARSPassword;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.identifier.ARSUser;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRegistration
extends ARSHeader {
    private static final Logger mLog = LoggerFactory.getLogger(DeviceRegistration.class);
    private static final int SECOND_HEADER_EXTENSION_FLAG = 24;
    private static final int[] EVENT = new int[]{25, 26};
    private static final int[] ENCODING = new int[]{27, 28, 29, 30, 31};
    private static final int DEVICE_IDENTIFIER_START = 24;
    private static final int DEVICE_IDENTIFIER_START_EXTENDED_HEADER = 32;
    private static final int[] BYTE_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private ARSDevice mDevice;
    private ARSUser mUser;
    private ARSPassword mPassword;
    private List<Identifier> mIdentifiers;

    public DeviceRegistration(BinaryMessage message, int offset) {
        super(message, offset);
        this.parsePayload();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DEVICE REGISTRATION");
        if (this.isValid()) {
            if (this.hasHeaderExtension()) {
                sb.append(this.isInitialEvent() ? "-INITIAL" : "-REFRESH");
            }
            if (this.hasDevice()) {
                sb.append(" DEVICE:").append(this.getDevice());
            }
            if (this.hasUser()) {
                sb.append(" USER:").append(this.getUser());
            }
            if (this.hasPassword()) {
                sb.append(" PW:").append(this.getPassword());
            }
        } else {
            sb.append(" - ERROR INVALID MESSAGE LENGTH");
        }
        return sb.toString();
    }

    public boolean isInitialEvent() {
        return this.getMessage().getInt(EVENT, this.getOffset()) == 1;
    }

    public ARSUser getUser() {
        return this.mUser;
    }

    public boolean hasUser() {
        return this.mUser != null;
    }

    public ARSPassword getPassword() {
        return this.mPassword;
    }

    public boolean hasPassword() {
        return this.mPassword != null;
    }

    public ARSDevice getDevice() {
        return this.mDevice;
    }

    public boolean hasDevice() {
        return this.mDevice != null;
    }

    private void parsePayload() {
        int pointer = this.getOffset();
        pointer = this.hasHeaderExtension() ? (pointer += 32) : (pointer += 24);
        int deviceIdentifierSize = this.getMessage().getInt(BYTE_VALUE, pointer);
        pointer += 8;
        if (deviceIdentifierSize > 0 && deviceIdentifierSize < 8) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < deviceIdentifierSize; ++x) {
                sb.append(this.getCharacter(pointer));
                pointer += 8;
            }
            this.mDevice = ARSDevice.createFrom(sb.toString());
        }
        int userIdentifierSize = this.getMessage().getInt(BYTE_VALUE, pointer);
        pointer += 8;
        if (userIdentifierSize > 0 && userIdentifierSize < 8) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < userIdentifierSize; ++x) {
                sb.append(this.getCharacter(pointer));
                pointer += 8;
            }
            this.mUser = ARSUser.createFrom(sb.toString());
        }
        int passwordSize = this.getMessage().getInt(BYTE_VALUE, pointer);
        pointer += 8;
        if (passwordSize > 0 && passwordSize < 8) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < passwordSize; ++x) {
                sb.append(this.getCharacter(pointer));
                pointer += 8;
            }
            this.mPassword = ARSPassword.createFrom(sb.toString());
        }
    }

    private char getCharacter(int offset) {
        return (char)this.getMessage().getByte(BYTE_VALUE, offset);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasUser()) {
                this.mIdentifiers.add(this.getUser());
            }
            if (this.hasDevice()) {
                this.mIdentifiers.add(this.getDevice());
            }
            if (this.hasPassword()) {
                this.mIdentifiers.add(this.getPassword());
            }
        }
        return this.mIdentifiers;
    }
}

