/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.ars;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSHeader;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSHeaderFactory;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPDUType;
import java.util.List;

public class ARSPacket
extends Packet {
    private ARSHeader mHeader;

    public ARSPacket(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ARS ").append(this.getHeader());
        return sb.toString();
    }

    @Override
    public ARSHeader getHeader() {
        if (this.mHeader == null) {
            ARSPDUType pduType = ARSHeader.getPDUType(this.getMessage(), this.getOffset());
            this.mHeader = ARSHeaderFactory.create(pduType, this.getMessage(), this.getOffset());
        }
        return this.mHeader;
    }

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getHeader().getIdentifiers();
    }
}

