/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.ipv4;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.PacketMessageFactory;
import io.github.dsheirer.module.decode.ip.UnknownPacket;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Header;
import java.util.ArrayList;
import java.util.List;

public class IPV4Packet
extends Packet {
    private IPV4Header mHeader;
    private IPacket mPayload;
    private List<Identifier> mIdentifiers;

    public IPV4Packet(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getHeader().isValid()) {
            sb.append(this.getHeader());
        } else {
            sb.append("IPV4 - INVALID HEADER");
            sb.append(" HDR:").append(this.getHeader().getMessage().toHexString());
        }
        if (this.hasPayload()) {
            if (this.getPayload() instanceof UnknownPacket) {
                sb.append(" PROTOCOL:").append((Object)this.getHeader().getProtocol());
            }
            sb.append(" ").append(this.getPayload().toString());
        } else {
            sb.append(" NO PAYLOAD!");
        }
        return sb.toString();
    }

    @Override
    public IPV4Header getHeader() {
        if (this.mHeader == null) {
            this.mHeader = new IPV4Header(this.getMessage(), this.getOffset());
        }
        return this.mHeader;
    }

    @Override
    public IPacket getPayload() {
        if (this.mPayload == null) {
            this.mPayload = this.getHeader().isValid() ? PacketMessageFactory.create(this.getHeader().getProtocol(), this.getMessage(), this.getOffset() + this.getHeader().getLength()) : new UnknownPacket(this.getMessage(), this.getOffset());
        }
        return this.mPayload;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getHeader().getFromAddress());
            this.mIdentifiers.add(this.getHeader().getToAddress());
            if (this.hasPayload()) {
                this.mIdentifiers.addAll(this.getPayload().getIdentifiers());
            }
        }
        return this.mIdentifiers;
    }
}

