/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.ipv4;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.ipv4.IPV4Identifier;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.IPProtocol;
import io.github.dsheirer.module.decode.p25.identifier.ipv4.APCO25IpAddress;

public class IPV4Header
extends Header {
    private static final int[] VERSION = new int[]{0, 1, 2, 3};
    private static final int[] HEADER_LENGTH = new int[]{4, 5, 6, 7};
    private static final int[] TOTAL_LENGTH = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] PROTOCOL = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] FROM_ADDRESS = new int[]{96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    private static final int[] TO_ADDRESS = new int[]{128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159};
    private IPV4Identifier mFromAddress;
    private IPV4Identifier mToAddress;

    public IPV4Header(BinaryMessage message, int offset) {
        super(message, offset);
        this.checkValid();
    }

    private void checkValid() {
        int headerLength = this.getLength();
        if (headerLength < 40) {
            this.setValid(false);
            return;
        }
        if (this.getMessage().size() < headerLength + this.getOffset()) {
            this.setValid(false);
            return;
        }
        int totalLength = this.getTotalLength();
        if (totalLength < headerLength) {
            this.setValid(false);
            return;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IP FROM:").append(this.getFromAddress());
        sb.append(" TO:").append(this.getToAddress());
        return sb.toString();
    }

    public static int getIPVersion(BinaryMessage message, int offset) {
        return message.getInt(VERSION, offset);
    }

    public int getIPVersion() {
        return IPV4Header.getIPVersion(this.getMessage(), this.getOffset());
    }

    @Override
    public int getLength() {
        return this.getMessage().getInt(HEADER_LENGTH, this.getOffset()) * 32;
    }

    public int getTotalLength() {
        return this.getMessage().getInt(TOTAL_LENGTH, this.getOffset()) * 8;
    }

    public IPProtocol getProtocol() {
        return IPProtocol.fromValue(this.getMessage().getInt(PROTOCOL, this.getOffset()));
    }

    public IPV4Identifier getFromAddress() {
        if (this.mFromAddress == null) {
            this.mFromAddress = APCO25IpAddress.createFrom(this.getMessage().getInt(FROM_ADDRESS, this.getOffset()));
        }
        return this.mFromAddress;
    }

    public IPV4Identifier getToAddress() {
        if (this.mToAddress == null) {
            this.mToAddress = APCO25IpAddress.createTo(this.getMessage().getInt(TO_ADDRESS, this.getOffset()));
        }
        return this.mToAddress;
    }
}

