/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.sms;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.hytera.sds.DestinationId;
import io.github.dsheirer.module.decode.ip.hytera.sds.Encoding;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraToken;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenHeader;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenType;
import io.github.dsheirer.module.decode.ip.hytera.sds.MessageId;
import io.github.dsheirer.module.decode.ip.hytera.sds.Payload;
import io.github.dsheirer.module.decode.ip.hytera.sds.SourceId;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class HyteraSmsPacket
implements IPacket {
    private HyteraTokenHeader mHeader;
    private String mSMS;
    private RadioIdentifier mSourceRadio;
    private RadioIdentifier mDestinationRadio;
    private List<Identifier> mIdentifiers;
    private MessageId mMessageId;

    public HyteraSmsPacket(HyteraTokenHeader header) {
        this.mHeader = header;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HYTERA LONG SMS");
        if (this.hasSMS()) {
            sb.append(":").append(this.getSMS());
        }
        if (this.hasMessageId()) {
            sb.append(" ID:").append(this.getMessageId().getId());
        }
        if (this.hasSource()) {
            sb.append(" SOURCE:").append(this.getSource());
        }
        if (this.hasDestination()) {
            sb.append("DESTINATION:").append(this.getDestination());
        }
        return sb.toString();
    }

    @Override
    public HyteraTokenHeader getHeader() {
        return this.mHeader;
    }

    public MessageId getMessageId() {
        HyteraToken idToken;
        if (this.mMessageId == null && (idToken = this.getHeader().getTokenByType(HyteraTokenType.ID_MESSAGE)) instanceof MessageId) {
            MessageId messageId;
            this.mMessageId = messageId = (MessageId)idToken;
        }
        return this.mMessageId;
    }

    public boolean hasMessageId() {
        return this.getMessageId() != null;
    }

    public RadioIdentifier getSource() {
        HyteraToken sourceToken;
        if (this.mSourceRadio == null && (sourceToken = this.getHeader().getTokenByType(HyteraTokenType.ID_SOURCE)) instanceof SourceId) {
            SourceId sourceId = (SourceId)sourceToken;
            this.mSourceRadio = DmrTier3Radio.createFrom(sourceId.getId());
        }
        return this.mSourceRadio;
    }

    public boolean hasSource() {
        return this.getSource() != null;
    }

    public RadioIdentifier getDestination() {
        HyteraToken destinationToken;
        if (this.mDestinationRadio == null && (destinationToken = this.getHeader().getTokenByType(HyteraTokenType.ID_DESTINATION)) instanceof DestinationId) {
            DestinationId destinationId = (DestinationId)destinationToken;
            this.mDestinationRadio = DmrTier3Radio.createTo(destinationId.getId());
        }
        return this.mDestinationRadio;
    }

    public boolean hasDestination() {
        return this.getDestination() != null;
    }

    public boolean hasSMS() {
        return this.getSMS() != null;
    }

    public String getSMS() {
        HyteraToken encodingToken;
        if (this.mSMS == null && (encodingToken = this.getHeader().getTokenByType(HyteraTokenType.ENCODING)) instanceof Encoding) {
            Encoding encoding = (Encoding)encodingToken;
            HyteraToken payloadToken = this.getHeader().getTokenByType(HyteraTokenType.PAYLOAD);
            if (payloadToken instanceof Payload) {
                Payload payload = (Payload)payloadToken;
                switch (encoding.getEncoding()) {
                    case ISO_7: {
                        this.mSMS = this.parseISO7Payload(payload.getPayload());
                        break;
                    }
                    case ISO_8: {
                        this.mSMS = this.parseISO8Payload(payload.getPayload());
                        break;
                    }
                    case UNICODE: {
                        this.mSMS = this.parseUnicodePayload(payload.getPayload());
                        break;
                    }
                    case GBK: {
                        this.mSMS = this.parseGB2312Payload(payload.getPayload());
                    }
                }
            }
        }
        return this.mSMS;
    }

    private String parseGB2312Payload(BinaryMessage message) {
        int length = message.size();
        if (length > 16) {
            try {
                return message.parseGB2312(0, length / 16);
            }
            catch (UnsupportedEncodingException uee) {
                return "(GB2312 unsupported decoding)";
            }
        }
        return "(insufficient data)";
    }

    private String parseUnicodePayload(BinaryMessage message) {
        int length = message.size();
        if (length > 16) {
            return message.parseUnicode(0, length / 16);
        }
        return "(insufficient data)";
    }

    private String parseISO7Payload(BinaryMessage message) {
        int length = message.size();
        if (length > 7) {
            return message.parseISO7(0, length / 7);
        }
        return "(insufficient data)";
    }

    private String parseISO8Payload(BinaryMessage message) {
        int length = message.size();
        if (length > 8) {
            return message.parseISO8(0, length / 8);
        }
        return "(insufficient data)";
    }

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public boolean hasPayload() {
        return false;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasSource()) {
                this.mIdentifiers.add(this.getSource());
            }
            if (this.hasDestination()) {
                this.mIdentifiers.add(this.getDestination());
            }
        }
        return this.mIdentifiers;
    }
}

