/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.shortdata;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.header.hytera.HyteraDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.packet.PacketSequence;
import io.github.dsheirer.module.decode.ip.IHeader;
import io.github.dsheirer.module.decode.ip.IPacket;
import java.util.List;

public class HyteraShortDataPacket
implements IPacket {
    private final PacketSequence mPacketSequence;
    private CorrectedBinaryMessage mMessage;

    public HyteraShortDataPacket(PacketSequence packetSequence, CorrectedBinaryMessage payload) {
        this.mPacketSequence = packetSequence;
        this.mMessage = payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getPacketSequence().getPacketSequenceHeader().getSlotType().getColorCode());
        sb.append(" HYTERA SHORT DATA MESSAGE FM:").append(this.getPacketSequence().getPacketSequenceHeader().getSourceLLID());
        sb.append(" TO:").append(this.getPacketSequence().getPacketSequenceHeader().getDestinationLLID());
        if (this.getPacketSequence().isEncrypted()) {
            HyteraDataEncryptionHeader hdeh = (HyteraDataEncryptionHeader)this.getPacketSequence().getProprietaryDataHeader();
            sb.append(" ENCRYPTED ALGORITHM:").append((Object)hdeh.getAlgorithm());
            sb.append(" KEY:").append(hdeh.getKeyId());
            sb.append(" IV:").append(hdeh.getIV());
        }
        sb.append(" SHORT DATA:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    @Override
    public IHeader getHeader() {
        return null;
    }

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public boolean hasPayload() {
        return false;
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public PacketSequence getPacketSequence() {
        return this.mPacketSequence;
    }

    public boolean isEncrypted() {
        return this.getPacketSequence().isEncrypted();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getPacketSequence().getPacketSequenceHeader().getIdentifiers();
    }
}

