/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.sds;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraToken;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenType;

public class TmsMessageHeader
extends HyteraToken {
    private static int[] MESSAGE_LENGTH_BCD_THOUSANDS = new int[]{16, 17, 18, 19};
    private static int[] MESSAGE_LENGTH_BCD_HUNDREDS = new int[]{20, 21, 22, 23};
    private static int[] MESSAGE_LENGTH_BCD_TENS = new int[]{24, 25, 26, 27};
    private static int[] MESSAGE_LENGTH_BCD_ONES = new int[]{28, 29, 30, 31};
    private static int[] MESSAGE_FLAGS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};

    public TmsMessageHeader(CorrectedBinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MESSAGE HEADER LENGTH:").append(this.getMessageLength());
        sb.append(" FLAGS:").append(this.getFlags());
        return sb.toString();
    }

    @Override
    HyteraTokenType getTokenType() {
        return HyteraTokenType.TEXT_MESSAGE_SERVICE_HEADER;
    }

    public String getFlags() {
        return this.mMessage.getHex(MESSAGE_FLAGS, 4);
    }

    public int getMessageLength() {
        int length = this.mMessage.getInt(MESSAGE_LENGTH_BCD_THOUSANDS) * 1000;
        length += this.mMessage.getInt(MESSAGE_LENGTH_BCD_HUNDREDS) * 100;
        length += this.mMessage.getInt(MESSAGE_LENGTH_BCD_TENS) * 10;
        return length += this.mMessage.getInt(MESSAGE_LENGTH_BCD_ONES);
    }
}

