/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.CommunicationControl;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;

public class ProgrammingStatusMessage
extends MCGPPacket {
    private static final int[] SOURCE_UNIT_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMMUNICATION_CONTROL = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] MESSAGE_NUMERATOR = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SPARE = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] BLOCK_CODE = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int DATA_BLOCK_START = 72;
    private static final int DATA_BLOCK_END = 200;
    private CellocatorRadioIdentifier mSourceRadioId;
    private CommunicationControl mCommunicationControl;

    public ProgrammingStatusMessage(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(header, message, offset);
    }

    @Override
    public CellocatorRadioIdentifier getRadioId() {
        if (this.mSourceRadioId == null) {
            this.mSourceRadioId = CellocatorRadioIdentifier.createTo(this.getMessage().getInt(SOURCE_UNIT_ID, this.getOffset()));
        }
        return this.mSourceRadioId;
    }

    public CommunicationControl getCommunicationControl() {
        if (this.mCommunicationControl == null) {
            this.mCommunicationControl = new CommunicationControl(this.getMessage().getInt(COMMUNICATION_CONTROL, this.getOffset()));
        }
        return this.mCommunicationControl;
    }

    public int getMessageNumerator() {
        return this.getMessage().getInt(MESSAGE_NUMERATOR, this.getOffset());
    }

    public int getBlockCode() {
        return this.getMessage().getInt(BLOCK_CODE, this.getOffset());
    }

    public String getDataBlock() {
        return this.getMessage().getSubMessage(72 + this.getOffset(), 200 + this.getOffset()).toHexString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR RADIO:");
        sb.append(this.getRadioId());
        sb.append(" PROGRAM MESSAGE NUMBER:").append(this.getMessageNumerator());
        sb.append(" BLOCK:").append(this.getBlockCode());
        sb.append(" DATA:").append(this.getDataBlock());
        return sb.toString();
    }
}

