/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.fleetsync2.identifier.FleetsyncStatus;
import io.github.dsheirer.module.decode.fleetsync2.message.Fleetsync2Message;
import java.util.ArrayList;
import java.util.List;

public class Status
extends Fleetsync2Message {
    private static int[] STATUS = new int[]{21, 22, 23, 24, 25, 26, 27};
    private FleetsyncStatus mStatusIdentifier;
    private List<Identifier> mIdentifers;

    public Status(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    protected int getBlockCount() {
        return Status.hasFleetExtensionFlag(this.getMessage()) ? 2 : 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM:").append(this.getFromIdentifier()).append(" TO:").append(this.getToIdentifier());
        sb.append(" STATUS:").append(this.getStatus());
        if (Status.hasEmergencyFlag(this.getMessage())) {
            sb.append(" EMERGENCY");
        }
        if (Status.hasLoneWorkerFlag(this.getMessage())) {
            sb.append(" LONE WORKER");
        }
        if (Status.hasPagingFlag(this.getMessage())) {
            sb.append(" PAGING");
        }
        if (Status.hasAcknowledgeFlag(this.getMessage())) {
            sb.append(" ACKNOWLEDGE");
        }
        if (Status.hasANIFlag(this.getMessage())) {
            sb.append(" ANI");
        }
        return sb.toString();
    }

    public FleetsyncStatus getStatus() {
        if (this.mStatusIdentifier == null) {
            this.mStatusIdentifier = FleetsyncStatus.createUserStatus(this.getMessage().getInt(STATUS));
        }
        return this.mStatusIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifers == null) {
            this.mIdentifers = new ArrayList<Identifier>();
            this.mIdentifers.add(this.getFromIdentifier());
            this.mIdentifers.add(this.getToIdentifier());
            this.mIdentifers.add(this.getStatus());
        }
        return this.mIdentifers;
    }
}

