/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.fleetsync2.message.Fleetsync2Message;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class LocationReport
extends Fleetsync2Message {
    private static int[] GPS_HOURS = new int[]{172, 173, 174, 175, 176};
    private static int[] GPS_MINUTES = new int[]{177, 178, 179, 180, 181, 182};
    private static int[] GPS_SECONDS = new int[]{183, 184, 185, 186, 187, 188};
    private static int[] GPS_CHECKSUM = new int[]{213, 214, 215, 216, 217, 218, 219, 220};
    private static int[] LATITUDE_DEGREES_MINUTES = new int[]{221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236};
    private static int[] LATITUDE_FRACTIONAL_MINUTES = new int[]{238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251};
    private static int[] SPEED = new int[]{252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276};
    private static int[] GPS_CENTURY = new int[]{277, 278, 279, 280, 281, 282, 283, 284};
    private static int[] GPS_YEAR = new int[]{284, 286, 287, 288, 289, 290, 291};
    private static int[] GPS_MONTH = new int[]{292, 293, 294, 295};
    private static int[] GPS_DAY = new int[]{296, 297, 298, 299, 300};
    private static int[] LONGITUDE_DEGREES_MINUTES = new int[]{301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316};
    private static int[] LONGITUDE_FRACTIONAL_MINUTES = new int[]{318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331};
    private static int[] GPS_HEADING = new int[]{353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365};
    private static int[] GPS_SPEED = new int[]{484, 485, 486, 487, 488, 489, 490, 491};
    private static int[] GPS_SPEED_FRACTIONAL = new int[]{492, 493, 494, 495, 496, 497, 498, 499};
    private GeoPosition mGeoPosition;
    private Long mGPSTimestamp;
    private Double mGPSHeading;
    private Double mGPSSpeed;
    private List<Identifier> mIdentifers;

    public LocationReport(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    protected int getBlockCount() {
        return 8;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GPS FROM:").append(this.getFromIdentifier());
        sb.append(" TO:").append(this.getToIdentifier());
        sb.append(" ").append(this.getLocation());
        sb.append(" HEADING:").append(this.getHeading());
        sb.append(" SPEED:").append(this.getSpeed());
        sb.append(" TIME:").append(new Date(this.getGPSTime()));
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifers == null) {
            this.mIdentifers = new ArrayList<Identifier>();
            this.mIdentifers.add(this.getFromIdentifier());
            this.mIdentifers.add(this.getToIdentifier());
        }
        return this.mIdentifers;
    }

    public double getHeading() {
        if (this.mGPSHeading == null) {
            this.mGPSHeading = this.hasHeading() ? Double.valueOf((double)this.getHeadingValue() / 10.0) : Double.valueOf(0.0);
        }
        return this.mGPSHeading;
    }

    private int getHeadingValue() {
        return this.getMessage().getInt(GPS_HEADING);
    }

    private boolean hasHeading() {
        return this.getHeadingValue() != 4095;
    }

    public double getSpeed() {
        if (this.mGPSSpeed == null) {
            this.mGPSSpeed = (double)this.getMessage().getInt(GPS_SPEED) + (double)this.getMessage().getInt(GPS_SPEED_FRACTIONAL) / 255.0;
        }
        return this.mGPSSpeed;
    }

    public GeoPosition getLocation() {
        if (this.mGeoPosition == null) {
            this.mGeoPosition = new GeoPosition(this.getLatitude(), this.getLongitude());
        }
        return this.mGeoPosition;
    }

    private double getLatitude() {
        return this.convertDDMToDD(0, this.getMessage().getInt(LATITUDE_DEGREES_MINUTES), this.getMessage().getInt(LATITUDE_FRACTIONAL_MINUTES));
    }

    private double getLongitude() {
        return this.convertDDMToDD(1, this.getMessage().getInt(LONGITUDE_DEGREES_MINUTES), this.getMessage().getInt(LONGITUDE_FRACTIONAL_MINUTES));
    }

    public double convertDDMToDD(int hemisphere, int degreesMinutes, int decimalDegrees) {
        double retVal = 0.0;
        if (degreesMinutes != 0) {
            retVal += (double)(degreesMinutes / 100);
            int wholeMinutes = degreesMinutes % 100;
            if (wholeMinutes != 0) {
                retVal += (double)wholeMinutes / 60.0;
            }
        }
        if (decimalDegrees != 0) {
            retVal += (double)decimalDegrees / 600000.0;
        }
        if (hemisphere == 1) {
            retVal = -retVal;
        }
        return retVal;
    }

    public long getGPSTime() {
        if (this.mGPSTimestamp == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(1, 2000 + this.getMessage().getInt(GPS_YEAR));
            ((Calendar)calendar).add(2, this.getMessage().getInt(GPS_MONTH));
            ((Calendar)calendar).add(5, this.getMessage().getInt(GPS_DAY));
            ((Calendar)calendar).add(11, this.getMessage().getInt(GPS_HOURS));
            ((Calendar)calendar).add(12, this.getMessage().getInt(GPS_MINUTES));
            ((Calendar)calendar).add(13, this.getMessage().getInt(GPS_SECONDS));
            this.mGPSTimestamp = calendar.getTimeInMillis();
        }
        return this.mGPSTimestamp;
    }
}

