/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.fleetsync2.message.Fleetsync2Message;
import java.util.ArrayList;
import java.util.List;

public class AutomaticNumberIdentification
extends Fleetsync2Message {
    private List<Identifier> mIdentifers;

    public AutomaticNumberIdentification(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    protected int getBlockCount() {
        return AutomaticNumberIdentification.hasFleetExtensionFlag(this.getMessage()) ? 2 : 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM:").append(this.getFromIdentifier().formatted());
        if (AutomaticNumberIdentification.hasEmergencyFlag(this.getMessage())) {
            sb.append(" EMERGENCY");
        }
        if (AutomaticNumberIdentification.hasLoneWorkerFlag(this.getMessage())) {
            sb.append(" LONE WORKER");
        }
        if (AutomaticNumberIdentification.hasPagingFlag(this.getMessage())) {
            sb.append(" PAGING");
        }
        if (AutomaticNumberIdentification.hasAcknowledgeFlag(this.getMessage())) {
            sb.append(" ACKNOWLEDGE");
        }
        if (AutomaticNumberIdentification.hasANIFlag(this.getMessage())) {
            sb.append(" ANI");
        }
        return sb.toString().trim();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifers == null) {
            this.mIdentifers = new ArrayList<Identifier>();
            this.mIdentifers.add(this.getFromIdentifier());
        }
        return this.mIdentifers;
    }
}

