/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import io.github.dsheirer.message.IMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageItem {
    private static final Logger mLog = LoggerFactory.getLogger(MessageItem.class);
    private IMessage mMessage;
    private String mTimestamp;
    private String mProtocol;
    private String mText;

    public MessageItem(IMessage message) {
        this.mMessage = message;
    }

    public IMessage getMessage() {
        return this.mMessage;
    }

    public void dispose() {
        this.mMessage = null;
        this.mTimestamp = null;
        this.mProtocol = null;
        this.mText = null;
    }

    public String getTimestamp(SimpleDateFormat simpleDateFormat) {
        if (this.mTimestamp == null) {
            this.mTimestamp = simpleDateFormat.format(new Date(this.getMessage().getTimestamp()));
        }
        return this.mTimestamp;
    }

    public int getTimeslot() {
        return this.mMessage.getTimeslot();
    }

    public String getText() {
        if (this.mText == null) {
            try {
                this.mText = this.getMessage().toString();
            }
            catch (Throwable t) {
                mLog.error("Error accessing message toString() method - protocol [" + this.getProtocol() + "]", t);
                this.mText = "MESSAGE ITEM ENCOUNTERED PARSING ERROR";
            }
        }
        return this.mText;
    }

    public String getProtocol() {
        if (this.mProtocol == null) {
            this.mProtocol = this.getMessage().getProtocol().toString();
        }
        return this.mProtocol;
    }
}

