/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import io.github.dsheirer.filter.FilterEditor;
import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.module.decode.event.ClearableHistoryModel;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class HistoryManagementPanel<T>
extends JPanel {
    private ClearableHistoryModel mModel;
    private FilterSet<T> mFilterSet;
    private FilterEditor<T> mFilterEditor;
    private JButton mClearButton;
    private JButton mFilterButton;
    private JSlider mHistorySlider;
    private JLabel mHistoryTitleLabel;
    private JLabel mHistoryValueLabel;
    private String mFilterEditorTitle;

    public HistoryManagementPanel(ClearableHistoryModel model, String filterEditorTitle) {
        this.mModel = model;
        this.mFilterEditorTitle = filterEditorTitle;
        this.setLayout((LayoutManager)new MigLayout("insets 6 1 5 5", "[]5[]10[]5[]5[][grow]", ""));
        this.add(this.getFilterButton());
        this.add(this.getClearButton());
        this.add(this.getHistoryTitleLabel());
        this.add(this.getHistorySlider());
        this.add(this.getHistoryValueLabel());
        this.setEnabled(false);
    }

    public void updateFilterSet(FilterSet<T> filterSet) {
        this.mFilterSet = filterSet;
        if (this.mFilterEditor != null) {
            this.getFilterEditor().updateFilterSet(filterSet);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getClearButton().setEnabled(enabled);
        this.getFilterButton().setEnabled(enabled);
        this.getHistoryValueLabel().setEnabled(enabled);
        this.getHistoryTitleLabel().setEnabled(enabled);
        this.getHistorySlider().setEnabled(enabled);
    }

    private FilterEditor<T> getFilterEditor() {
        if (this.mFilterEditor == null) {
            this.mFilterEditor = new FilterEditor<T>(this.mFilterEditorTitle, this.getFilterButton(), this.mFilterSet);
        }
        return this.mFilterEditor;
    }

    private JButton getFilterButton() {
        if (this.mFilterButton == null) {
            this.mFilterButton = new JButton("Filters");
            this.mFilterButton.setToolTipText("Edit filters");
            this.mFilterButton.addActionListener(arg0 -> EventQueue.invokeLater(() -> this.getFilterEditor().setVisible(true)));
        }
        return this.mFilterButton;
    }

    private JButton getClearButton() {
        if (this.mClearButton == null) {
            this.mClearButton = new JButton("Clear");
            this.mClearButton.addActionListener(e -> this.mModel.clear());
            this.mClearButton.setToolTipText("Clears the history");
        }
        return this.mClearButton;
    }

    private JLabel getHistoryValueLabel() {
        if (this.mHistoryValueLabel == null) {
            this.mHistoryValueLabel = new JLabel(String.valueOf(200));
        }
        return this.mHistoryValueLabel;
    }

    private JLabel getHistoryTitleLabel() {
        if (this.mHistoryTitleLabel == null) {
            this.mHistoryTitleLabel = new JLabel("History:");
        }
        return this.mHistoryTitleLabel;
    }

    private JSlider getHistorySlider() {
        if (this.mHistorySlider == null) {
            this.mHistorySlider = new JSlider();
            this.mHistorySlider.setToolTipText("Adjust history size.  Double-click to reset to default 200");
            this.mHistorySlider.setMinimum(0);
            this.mHistorySlider.setMaximum(2000);
            this.mHistorySlider.setMinorTickSpacing(25);
            this.mHistorySlider.setMajorTickSpacing(500);
            this.mHistorySlider.setPaintTicks(false);
            this.mHistorySlider.setPaintLabels(false);
            this.mHistorySlider.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    if (SwingUtilities.isLeftMouseButton(arg0) && arg0.getClickCount() == 2) {
                        HistoryManagementPanel.this.mHistorySlider.setValue(200);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }
            });
            this.mHistorySlider.setValue(this.mModel.getHistorySize());
            this.mHistorySlider.addChangeListener(e -> {
                this.mModel.setHistorySize(this.mHistorySlider.getValue());
                this.getHistoryValueLabel().setText(String.valueOf(this.mHistorySlider.getValue()));
            });
        }
        return this.mHistorySlider;
    }
}

