/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import com.google.common.base.Joiner;
import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.module.decode.event.DecodeEventHistory;
import io.github.dsheirer.module.decode.event.DecodeEventModel;
import io.github.dsheirer.module.decode.event.HistoryManagementPanel;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.filter.DecodeEventFilterSet;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.swing.JTableColumnWidthMonitor;
import io.github.dsheirer.sample.Listener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeEventPanel
extends JPanel
implements Listener<ProcessingChain> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(DecodeEventPanel.class);
    private static final String TABLE_PREFERENCE_KEY = "decode.event.panel";
    private JTable mTable;
    private JTableColumnWidthMonitor mTableColumnWidthMonitor;
    private DecodeEventModel mEventModel = new DecodeEventModel();
    private DecodeEventHistory mCurrentEventHistory;
    private JScrollPane mEmptyScroller;
    private IconModel mIconModel;
    private AliasModel mAliasModel;
    private UserPreferences mUserPreferences;
    private TimestampCellRenderer mTimestampCellRenderer;
    private FilterSet<IDecodeEvent> mFilterSet = new DecodeEventFilterSet();
    private TableRowSorter<TableModel> mTableRowSorter;
    private HistoryManagementPanel<IDecodeEvent> mHistoryManagementPanel;

    public DecodeEventPanel(IconModel iconModel, UserPreferences userPreferences, AliasModel aliasModel) {
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[][grow,fill]"));
        this.mIconModel = iconModel;
        this.mAliasModel = aliasModel;
        this.mUserPreferences = userPreferences;
        this.mTimestampCellRenderer = new TimestampCellRenderer();
        this.mTable = new JTable(this.mEventModel);
        this.mTableRowSorter = new TableRowSorter<DecodeEventModel>(this.mEventModel);
        this.mTableRowSorter.setRowFilter(new EventRowFilter());
        this.mTable.setRowSorter(this.mTableRowSorter);
        this.mTable.setAutoResizeMode(3);
        this.mTableColumnWidthMonitor = new JTableColumnWidthMonitor(this.mUserPreferences, this.mTable, TABLE_PREFERENCE_KEY);
        this.updateCellRenderers();
        this.mHistoryManagementPanel = new HistoryManagementPanel(this.mEventModel, "Event Filter Editor");
        this.mHistoryManagementPanel.updateFilterSet(this.mFilterSet);
        this.add(this.mHistoryManagementPanel, "span,growx");
        this.mEmptyScroller = new JScrollPane(this.mTable);
        this.add(this.mEmptyScroller);
        this.mFilterSet.register(() -> this.mEventModel.fireTableDataChanged());
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.DECODE_EVENT || preferenceType == PreferenceType.TALKGROUP_FORMAT) {
            EventQueue.invokeLater(() -> this.mTimestampCellRenderer.updatePreferences());
        }
    }

    private void updateCellRenderers() {
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(this.mTimestampCellRenderer);
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(new DurationCellRenderer());
        this.mTable.getColumnModel().getColumn(3).setCellRenderer(new IdentifierCellRenderer(Role.FROM));
        this.mTable.getColumnModel().getColumn(4).setCellRenderer(new AliasedIdentifierCellRenderer(Role.FROM));
        this.mTable.getColumnModel().getColumn(5).setCellRenderer(new IdentifierCellRenderer(Role.TO));
        this.mTable.getColumnModel().getColumn(6).setCellRenderer(new AliasedIdentifierCellRenderer(Role.TO));
        this.mTable.getColumnModel().getColumn(7).setCellRenderer(new ChannelDescriptorCellRenderer());
        this.mTable.getColumnModel().getColumn(8).setCellRenderer(new FrequencyCellRenderer());
    }

    @Override
    public void receive(ProcessingChain processingChain) {
        if (this.mCurrentEventHistory != null) {
            this.mCurrentEventHistory.removeListener(this.mEventModel);
        }
        EventQueue.invokeLater(() -> {
            if (processingChain != null) {
                this.mCurrentEventHistory = processingChain.getDecodeEventHistory();
                this.mEventModel.clearAndSet(this.mCurrentEventHistory.getItems());
                processingChain.getDecodeEventHistory().addListener(this.mEventModel);
                this.mHistoryManagementPanel.setEnabled(true);
            } else {
                this.mCurrentEventHistory = null;
                this.mEventModel.clearAndSet(Collections.emptyList());
                this.mHistoryManagementPanel.setEnabled(false);
            }
        });
    }

    public class TimestampCellRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat mTimestampFormatter;

        public TimestampCellRenderer() {
            this.setHorizontalAlignment(0);
            this.updatePreferences();
        }

        public void updatePreferences() {
            this.mTimestampFormatter = DecodeEventPanel.this.mUserPreferences.getDecodeEventPreference().getTimestampFormat().getFormatter();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Long) {
                label.setText(this.mTimestampFormatter.format(new Date((Long)value)));
            } else {
                label.setText(null);
            }
            return label;
        }
    }

    public class EventRowFilter
    extends RowFilter<TableModel, Integer> {
        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            DecodeEventModel model;
            IDecodeEvent event;
            TableModel tableModel = entry.getModel();
            if (tableModel instanceof DecodeEventModel && (event = (IDecodeEvent)(model = (DecodeEventModel)tableModel).getItem(entry.getIdentifier())) != null) {
                return DecodeEventPanel.this.mFilterSet.canProcess(event) && DecodeEventPanel.this.mFilterSet.passes(event);
            }
            return false;
        }
    }

    public class DurationCellRenderer
    extends DefaultTableCellRenderer {
        private DecimalFormat mDecimalFormat = new DecimalFormat("0.0");

        public DurationCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            long duration;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String formatted = null;
            if (value instanceof Long && (duration = ((Long)value).longValue()) > 0L) {
                formatted = this.mDecimalFormat.format((double)duration / 1000.0);
            }
            label.setText(formatted);
            return label;
        }
    }

    public class IdentifierCellRenderer
    extends DefaultTableCellRenderer {
        protected Role mRole;

        public IdentifierCellRenderer(Role role) {
            this.mRole = role;
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof IdentifierCollection) {
                List<Identifier> identifiers = ((IdentifierCollection)value).getIdentifiers(this.mRole);
                label.setText(this.format(identifiers));
            } else {
                label.setText(null);
            }
            return label;
        }

        protected String format(List<Identifier> identifiers) {
            if (identifiers == null || identifiers.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Identifier identifier : identifiers) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (identifier.getForm() == Form.TALKGROUP || identifier.getForm() == Form.RADIO || identifier.getForm() == Form.PATCH_GROUP) {
                    sb.append(DecodeEventPanel.this.mUserPreferences.getTalkgroupFormatPreference().format(identifier));
                    continue;
                }
                sb.append(identifier);
            }
            return sb.toString();
        }
    }

    public class AliasedIdentifierCellRenderer
    extends DefaultTableCellRenderer {
        private Role mRole;

        public AliasedIdentifierCellRenderer(Role role) {
            this.mRole = role;
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            AliasList aliasList;
            IdentifierCollection identifierCollection;
            List<Identifier> identifiers;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color color = DecodeEventPanel.this.mTable.getForeground();
            ImageIcon icon = null;
            String text = null;
            if (value instanceof IdentifierCollection && (identifiers = (identifierCollection = (IdentifierCollection)value).getIdentifiers(this.mRole)) != null && !identifiers.isEmpty() && (aliasList = DecodeEventPanel.this.mAliasModel.getAliasList(identifierCollection)) != null) {
                StringBuilder sb = new StringBuilder();
                for (Identifier identifier : identifiers) {
                    List<Alias> aliases = aliasList.getAliases(identifier);
                    if (aliases.isEmpty()) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(Joiner.on((String)", ").skipNulls().join(aliases));
                    color = aliases.get(0).getDisplayColor();
                    icon = DecodeEventPanel.this.mIconModel.getIcon(aliases.get(0).getIconName(), 12);
                }
                text = sb.toString();
            }
            label.setText(text);
            label.setForeground(color);
            label.setIcon(icon);
            return label;
        }
    }

    public class ChannelDescriptorCellRenderer
    extends DefaultTableCellRenderer {
        public ChannelDescriptorCellRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    public class FrequencyCellRenderer
    extends DefaultTableCellRenderer {
        private DecimalFormat mFrequencyFormatter = new DecimalFormat("0.00000");

        public FrequencyCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            IChannelDescriptor channelDescriptor;
            long frequency;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String formatted = null;
            if (value instanceof IChannelDescriptor && (frequency = (channelDescriptor = (IChannelDescriptor)value).getDownlinkFrequency()) > 0L) {
                formatted = this.mFrequencyFormatter.format((double)frequency / 1000000.0);
            }
            label.setText(formatted);
            return label;
        }
    }
}

