/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import com.google.common.base.Joiner;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.protocol.Protocol;

public class DecodeEvent
implements IDecodeEvent {
    private long mTimeStart;
    private long mTimeEnd;
    private DecodeEventType mDecodeEventType;
    private IdentifierCollection mIdentifierCollection;
    private IChannelDescriptor mChannelDescriptor;
    private String mDetails;
    private Protocol mProtocol;
    private int mTimeslot = -1;

    public DecodeEvent(DecodeEventType decodeEventType, long start) {
        this.mDecodeEventType = decodeEventType;
        this.mTimeStart = start;
    }

    public static DecodeEventBuilder builder(DecodeEventType decodeEventType, long timeStart) {
        return new DecodeEventBuilder(decodeEventType, timeStart);
    }

    public void end(long timestamp) {
        if (timestamp > this.mTimeStart) {
            this.mTimeEnd = timestamp;
        }
    }

    public void update(long timestamp) {
        this.end(timestamp);
    }

    @Override
    public long getTimeStart() {
        return this.mTimeStart;
    }

    @Override
    public long getTimeEnd() {
        return this.mTimeEnd;
    }

    @Override
    public long getDuration() {
        if (this.mTimeEnd < this.mTimeStart) {
            return 0L;
        }
        return this.mTimeEnd - this.mTimeStart;
    }

    public void setDuration(long duration) {
        this.mTimeEnd = this.mTimeStart + duration;
    }

    @Override
    public DecodeEventType getEventType() {
        return this.mDecodeEventType;
    }

    @Override
    public IdentifierCollection getIdentifierCollection() {
        return this.mIdentifierCollection;
    }

    public void setIdentifierCollection(IdentifierCollection identifierCollection) {
        this.mIdentifierCollection = identifierCollection;
    }

    @Override
    public IChannelDescriptor getChannelDescriptor() {
        return this.mChannelDescriptor;
    }

    public void setChannelDescriptor(IChannelDescriptor channelDescriptor) {
        this.mChannelDescriptor = channelDescriptor;
    }

    @Override
    public String getDetails() {
        return this.mDetails;
    }

    public void setDetails(String details) {
        this.mDetails = details;
    }

    @Override
    public Protocol getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.mProtocol = protocol;
    }

    @Override
    public int getTimeslot() {
        return this.mTimeslot;
    }

    @Override
    public boolean hasTimeslot() {
        return this.mTimeslot >= 0;
    }

    public void setTimeslot(int timeslot) {
        this.mTimeslot = timeslot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mProtocol);
        sb.append(" DECODE EVENT: ").append((Object)this.getEventType());
        sb.append(" DETAILS:").append(this.getDetails());
        if (this.mIdentifierCollection != null) {
            sb.append(" IDS:").append(Joiner.on((String)",").join(this.mIdentifierCollection.getIdentifiers()));
        }
        sb.append(" DURATION:").append(this.getDuration());
        sb.append(" CHANNEL:").append(this.mChannelDescriptor);
        return sb.toString();
    }

    public static class DecodeEventBuilder {
        protected long mTimeStart;
        protected long mDuration;
        protected DecodeEventType mDecodeEventType;
        protected IdentifierCollection mIdentifierCollection;
        protected IChannelDescriptor mChannelDescriptor;
        protected String mDetails;
        protected Protocol mProtocol = Protocol.UNKNOWN;
        protected int mTimeslot = -1;

        public DecodeEventBuilder(DecodeEventType decodeEventType, long timeStart) {
            this.mDecodeEventType = decodeEventType;
            this.mTimeStart = timeStart;
        }

        public DecodeEventBuilder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public DecodeEventBuilder end(long timestamp) {
            this.mDuration = timestamp - this.mTimeStart;
            return this;
        }

        public DecodeEventBuilder channel(IChannelDescriptor channelDescriptor) {
            this.mChannelDescriptor = channelDescriptor;
            return this;
        }

        public DecodeEventBuilder identifiers(IdentifierCollection identifierCollection) {
            this.mIdentifierCollection = identifierCollection;
            return this;
        }

        public DecodeEventBuilder details(String details) {
            this.mDetails = details;
            return this;
        }

        public DecodeEventBuilder protocol(Protocol protocol) {
            this.mProtocol = protocol;
            return this;
        }

        public DecodeEventBuilder timeslot(int timeslot) {
            this.mTimeslot = timeslot;
            return this;
        }

        public DecodeEvent build() {
            DecodeEvent decodeEvent = new DecodeEvent(this.mDecodeEventType, this.mTimeStart);
            decodeEvent.setChannelDescriptor(this.mChannelDescriptor);
            decodeEvent.setDetails(this.mDetails);
            decodeEvent.setDuration(this.mDuration);
            decodeEvent.setIdentifierCollection(this.mIdentifierCollection);
            decodeEvent.setProtocol(this.mProtocol);
            decodeEvent.setTimeslot(this.mTimeslot);
            return decodeEvent;
        }
    }
}

