/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import java.awt.EventQueue;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class ClearableHistoryModel<T>
extends AbstractTableModel {
    public static final int DEFAULT_HISTORY_SIZE = 200;
    private LinkedList<T> mItems = new LinkedList();
    private int mHistorySize = 200;

    public T getItem(int index) {
        if (index < this.mItems.size()) {
            return this.mItems.get(index);
        }
        return null;
    }

    public void add(T item) {
        if (this.mItems.contains(item)) {
            int itemRow = this.mItems.indexOf(item);
            this.fireTableRowsUpdated(itemRow, itemRow);
        } else {
            this.mItems.addFirst(item);
            this.fireTableRowsInserted(0, 0);
            while (this.mItems.size() > this.mHistorySize) {
                this.mItems.removeLast();
                this.fireTableRowsDeleted(this.mItems.size() - 1, this.mItems.size() - 1);
            }
        }
    }

    public void clear() {
        EventQueue.invokeLater(() -> {
            this.mItems.clear();
            this.fireTableDataChanged();
        });
    }

    public void clearAndSet(List<T> items) {
        EventQueue.invokeLater(() -> {
            this.mItems.clear();
            this.fireTableDataChanged();
            for (Object item : items) {
                this.add(item);
            }
        });
    }

    public int getHistorySize() {
        return this.mHistorySize;
    }

    public void setHistorySize(int historySize) {
        this.mHistorySize = historySize;
    }

    @Override
    public int getRowCount() {
        return this.mItems.size();
    }
}

