/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.voice;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.DMRBurst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class VoiceMessage
extends DMRBurst {
    public static int[] FRAME_1_IV_FRAGMENT = new int[]{95, 91, 87, 83};
    public static int[] FRAME_2_IV_FRAGMENT = new int[]{215, 211, 207, 203};
    public static int[] FRAME_3_IV_FRAGMENT = new int[]{287, 283, 279, 275};

    public VoiceMessage(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, long timestamp, int timeslot) {
        super(syncPattern, message, cach, timestamp, timeslot);
    }

    public List<byte[]> getAMBEFrames() {
        int i;
        ArrayList<byte[]> frames = new ArrayList<byte[]>();
        byte[] frame_1 = new byte[9];
        byte[] frame_2 = new byte[9];
        byte[] frame_3 = new byte[9];
        for (i = 0; i < 9; ++i) {
            frame_1[i] = this.getMessage().getByte(24 + i * 8);
        }
        for (i = 0; i < 4; ++i) {
            frame_2[i] = this.getMessage().getByte(96 + i * 8);
        }
        frame_3[4] = (byte)(this.getMessage().getByte(128) & 0xF0 | this.getMessage().getByte(180) >> 4);
        for (i = 0; i < 4; ++i) {
            frame_2[5 + i] = this.getMessage().getByte(184 + i * 8);
        }
        for (i = 0; i < 9; ++i) {
            frame_3[i] = this.getMessage().getByte(216 + i * 8);
        }
        frames.add(frame_1);
        frames.add(frame_2);
        frames.add(frame_3);
        return frames;
    }

    public byte[] getIvFragments() {
        byte[] fragments = new byte[]{(byte)this.getMessage().getInt(FRAME_1_IV_FRAGMENT), (byte)this.getMessage().getInt(FRAME_2_IV_FRAGMENT), (byte)this.getMessage().getInt(FRAME_3_IV_FRAGMENT)};
        return fragments;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

