/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

public enum UnifiedDataTransportFormat {
    BINARY("BINARY"),
    MOBILE_SUBSCRIBER_OR_TALKGROUP_ADDRESS("MS OR TG ADDRESS"),
    BCD_4_BITS("4-BIT BCD"),
    ASCII_7("ISO 7-BIT"),
    ASCII_8("ISO 8-BIT"),
    NMEA_GPS_LOCATION_CODED("NMEA GPS CODED"),
    IP_ADDRESS("IP ADDRESS"),
    UNICODE_16("16-BIT UNICODE"),
    VENDOR_PROPRIETARY_8("VENDOR SPECIFIC-8"),
    VENDOR_PROPRIETARY_9("VENDOR SPECIFIC-9"),
    MIXED_FORMAT("MIXED ADDRESS AND UNICODE"),
    UNKNOWN("UNKNOWN");

    private String mLabel;

    private UnifiedDataTransportFormat(String label) {
        this.mLabel = label;
    }

    public static UnifiedDataTransportFormat fromValue(int value) {
        switch (value) {
            case 0: {
                return BINARY;
            }
            case 1: {
                return MOBILE_SUBSCRIBER_OR_TALKGROUP_ADDRESS;
            }
            case 2: {
                return BCD_4_BITS;
            }
            case 3: {
                return ASCII_7;
            }
            case 4: {
                return ASCII_8;
            }
            case 5: {
                return NMEA_GPS_LOCATION_CODED;
            }
            case 6: {
                return IP_ADDRESS;
            }
            case 7: {
                return UNICODE_16;
            }
            case 8: {
                return VENDOR_PROPRIETARY_8;
            }
            case 9: {
                return VENDOR_PROPRIETARY_9;
            }
            case 10: {
                return MIXED_FORMAT;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.mLabel;
    }
}

