/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.usb;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCDMR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceType;
import java.util.ArrayList;
import java.util.List;

public class USBData
extends DataMessage {
    private static final int[] SERVICE_TYPE = new int[]{0, 1, 2, 3};
    private static final int[] RESPONSE_DELAY = new int[]{4, 5};
    private static final int PAYLOAD_CONTENT_FLAG = 6;
    private static final int RESERVED_FLAG = 7;
    private static final int PARAMETERS_START = 8;
    private static final int[] TARGET_RADIO = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mTargetRadio;

    public USBData(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
        int correctedBitCount = CRCDMR.correctCCITT80(message, 0, 80, 13107);
        this.setValid(correctedBitCount < 2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" USB DATA BLOCK");
        sb.append(" TO:").append(this.getTargetRadio());
        sb.append(" SERVICE:").append((Object)this.getServiceType());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public static ServiceType getServiceType(CorrectedBinaryMessage message) {
        return ServiceType.fromValue(message.getInt(SERVICE_TYPE));
    }

    public ServiceType getServiceType() {
        return USBData.getServiceType(this.getMessage());
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_RADIO));
        }
        return this.mTargetRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetRadio());
        }
        return this.mIdentifiers;
    }
}

