/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.packet;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock;
import io.github.dsheirer.module.decode.dmr.message.data.header.PacketSequenceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.UDTHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.hytera.HyteraDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.motorola.MNISProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.motorola.MotorolaDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.packet.DMRPacketMessage;
import io.github.dsheirer.module.decode.dmr.message.data.packet.PacketSequence;
import io.github.dsheirer.module.decode.dmr.message.data.packet.UDTShortMessageService;
import io.github.dsheirer.module.decode.dmr.message.type.ApplicationType;
import io.github.dsheirer.module.decode.dmr.message.type.DataPacketFormat;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import io.github.dsheirer.module.decode.ip.DefinedShortDataPacket;
import io.github.dsheirer.module.decode.ip.UnknownPacket;
import io.github.dsheirer.module.decode.ip.hytera.rrs.HyteraRrsPacket;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenHeader;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraUnknownPacket;
import io.github.dsheirer.module.decode.ip.hytera.shortdata.HyteraShortDataPacket;
import io.github.dsheirer.module.decode.ip.hytera.sms.HyteraSmsPacket;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Header;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPPacket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSequenceMessageFactory {
    private static final Logger mLog = LoggerFactory.getLogger(PacketSequenceMessageFactory.class);

    public static IMessage create(PacketSequence packetSequence) {
        if (packetSequence != null) {
            UDTHeader header;
            if (packetSequence.hasPacketSequenceHeader()) {
                PacketSequenceHeader primaryHeader = packetSequence.getPacketSequenceHeader();
                CorrectedBinaryMessage packet = PacketSequenceMessageFactory.getPacket(packetSequence, primaryHeader.isConfirmedData());
                if (packet != null) {
                    switch (primaryHeader.getServiceAccessPoint()) {
                        case IP_PACKET_DATA: {
                            return PacketSequenceMessageFactory.createIPPacketData(packetSequence, packet);
                        }
                        case PROPRIETARY_DATA: {
                            return PacketSequenceMessageFactory.createProprietary(packetSequence, packet);
                        }
                        case SHORT_DATA: {
                            return PacketSequenceMessageFactory.createDefinedShortData(packetSequence, packet);
                        }
                    }
                    mLog.info("Unknown Packet SAP: " + String.valueOf((Object)primaryHeader.getServiceAccessPoint()) + " - returning unknown packet");
                    return new DMRPacketMessage(packetSequence, new UnknownPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                }
            } else if (packetSequence.hasUDTHeader() && packetSequence.hasDataBlocks() && (header = packetSequence.getUDTHeader()).isShortData()) {
                CorrectedBinaryMessage payload = PacketSequenceMessageFactory.getUnconfirmedPayload(packetSequence.getDataBlocks());
                return new UDTShortMessageService(header, payload);
            }
        }
        return null;
    }

    public static CorrectedBinaryMessage getUnconfirmedPayload(List<DataBlock> dataBlocks) {
        if (!dataBlocks.isEmpty()) {
            int length = 0;
            ArrayList<CorrectedBinaryMessage> fragments = new ArrayList<CorrectedBinaryMessage>();
            for (DataBlock dataBlock : dataBlocks) {
                CorrectedBinaryMessage fragment = dataBlock.getUnConfirmedPayload();
                length += fragment.size();
                fragments.add(fragment);
            }
            CorrectedBinaryMessage combined = new CorrectedBinaryMessage(length);
            int pointer = 0;
            for (CorrectedBinaryMessage fragment : fragments) {
                combined.load(pointer, fragment);
                pointer += fragment.size();
            }
            return combined;
        }
        return null;
    }

    public static IMessage createProprietary(PacketSequence packetSequence, CorrectedBinaryMessage packet) {
        ProprietaryDataHeader secondaryHeader = packetSequence.getProprietaryDataHeader();
        if (secondaryHeader instanceof MNISProprietaryDataHeader) {
            ApplicationType applicationType = ((MNISProprietaryDataHeader)secondaryHeader).getApplicationType();
            switch (applicationType) {
                case AUTOMATIC_REGISTRATION_SERVICE: {
                    return new DMRPacketMessage(packetSequence, new ARSPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                }
                case MNIS_LRRP: 
                case LOCATION_REQUEST_RESPONSE_PROTOCOL: {
                    return new DMRPacketMessage(packetSequence, new LRRPPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                }
                case EXTENSIBLE_COMMAND_MESSAGE_PROTOCOL: {
                    return new DMRPacketMessage(packetSequence, new XCMPPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                }
            }
            mLog.info("Unknown MNIS Application Type: " + MNISProprietaryDataHeader.getApplicationTypeValue(packet));
            return new DMRPacketMessage(packetSequence, new UnknownPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
        }
        if (secondaryHeader instanceof HyteraDataEncryptionHeader) {
            HyteraDataEncryptionHeader hdeh = (HyteraDataEncryptionHeader)secondaryHeader;
            ServiceAccessPoint sap = hdeh.getServiceAccessPoint();
            switch (sap) {
                case SHORT_DATA: {
                    return new DMRPacketMessage(packetSequence, new HyteraShortDataPacket(packetSequence, packet), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                }
                case PROPRIETARY_DATA: {
                    HyteraTokenHeader hyteraTokenHeader = new HyteraTokenHeader(packet);
                    if (hyteraTokenHeader.isSMSMessage()) {
                        return new DMRPacketMessage(packetSequence, new HyteraSmsPacket(hyteraTokenHeader), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                    }
                    return new DMRPacketMessage(packetSequence, new HyteraUnknownPacket(hyteraTokenHeader), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
                }
            }
            return new DMRPacketMessage(packetSequence, new UnknownPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
        }
        if (secondaryHeader instanceof MotorolaDataEncryptionHeader && packetSequence.getPacketSequenceHeader().getDataPacketFormat() == DataPacketFormat.DEFINED_SHORT_DATA) {
            return PacketSequenceMessageFactory.createDefinedShortData(packetSequence, packet);
        }
        if (packetSequence.getProprietaryDataHeader() != null) {
            mLog.info("Unknown Proprietary Packet Header Type - creating unknown packet. Data Packet Format: " + String.valueOf((Object)packetSequence.getPacketSequenceHeader().getDataPacketFormat()) + " Proprietary Header: " + String.valueOf(packetSequence.getProprietaryDataHeader().getClass()));
        }
        return new DMRPacketMessage(packetSequence, new UnknownPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
    }

    public static IMessage createIPPacketData(PacketSequence packetSequence, CorrectedBinaryMessage packet) {
        int version = IPV4Header.getIPVersion(packet, 0);
        switch (version) {
            case 4: {
                return new DMRPacketMessage(packetSequence, new IPV4Packet(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
            }
        }
        mLog.info("Unrecognized IP Packet Version: " + version + " - returning unknown packet");
        return new DMRPacketMessage(packetSequence, new UnknownPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
    }

    public static IMessage createDefinedShortData(PacketSequence packetSequence, CorrectedBinaryMessage packet) {
        HyteraTokenHeader hyteraTokenHeader = new HyteraTokenHeader(packet);
        if (hyteraTokenHeader.isRRSMessage()) {
            return new DMRPacketMessage(packetSequence, new HyteraRrsPacket(hyteraTokenHeader), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
        }
        return new DMRPacketMessage(packetSequence, new DefinedShortDataPacket(packet, 0), packet, packetSequence.getTimeslot(), packetSequence.getPacketSequenceHeader().getTimestamp());
    }

    public static CorrectedBinaryMessage getPacket(PacketSequence sequence, boolean confirmed) {
        Object prefix;
        ArrayList<Object> fragments = new ArrayList<Object>();
        int length = 0;
        if (sequence.hasProprietaryDataHeader() && (prefix = sequence.getProprietaryDataHeader().getPacketPrefix()) != null) {
            fragments.add(prefix);
            length += ((BinaryMessage)prefix).size();
        }
        for (DataBlock dataBlock : sequence.getDataBlocks()) {
            CorrectedBinaryMessage correctedBinaryMessage = confirmed ? dataBlock.getConfirmedPayload() : dataBlock.getUnConfirmedPayload();
            fragments.add(correctedBinaryMessage);
            length += correctedBinaryMessage.size();
        }
        if (length > 0) {
            CorrectedBinaryMessage packet = new CorrectedBinaryMessage(length);
            for (CorrectedBinaryMessage correctedBinaryMessage : fragments) {
                for (int x = 0; x < correctedBinaryMessage.size(); ++x) {
                    try {
                        packet.add(correctedBinaryMessage.get(x));
                        continue;
                    }
                    catch (BitSetFullException bsfe) {
                        mLog.error("BitSet full while assembling packet fragments");
                        return packet;
                    }
                }
            }
            return packet;
        }
        return null;
    }

    public static boolean isConfirmedDataBlocks(List<DataBlock> dataBlocks) {
        int sequenceNumber = 0;
        for (DataBlock dataBlock : dataBlocks) {
            if (dataBlock.getDataBlockSerialNumber() == sequenceNumber) {
                ++sequenceNumber;
                continue;
            }
            return false;
        }
        return true;
    }
}

