/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.Activity;
import java.util.Collections;
import java.util.List;

public class ActivityUpdateMessage
extends ShortLCMessage {
    private static final int[] TIMESLOT_1_ACTIVITY = new int[]{4, 5, 6, 7};
    private static final int[] TIMESLOT_2_ACTIVITY = new int[]{8, 9, 10, 11};
    private static final int[] TIMESLOT_1_HASH_ADDRESS = new int[]{12, 13, 14, 15, 16, 17, 18, 19};
    private static final int[] TIMESLOT_2_HASH_ADDRESS = new int[]{20, 21, 22, 23, 24, 25, 26, 27};

    public ActivityUpdateMessage(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC ERROR] ");
        }
        sb.append("SLC TS1:");
        sb.append((Object)this.getActivityTS1());
        if (this.getActivityTS1() != Activity.IDLE) {
            sb.append(" [").append(this.getHashAddressTS1()).append("]");
        }
        sb.append(" TS2:");
        sb.append((Object)this.getActivityTS2());
        if (this.getActivityTS2() != Activity.IDLE) {
            sb.append(" [").append(this.getHashAddressTS2()).append("]");
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public Activity getActivityTS1() {
        return Activity.fromValue(this.getMessage().getInt(TIMESLOT_1_ACTIVITY));
    }

    public Activity getActivityTS2() {
        return Activity.fromValue(this.getMessage().getInt(TIMESLOT_2_ACTIVITY));
    }

    public String getHashAddressTS1() {
        return this.getMessage().getHex(TIMESLOT_1_HASH_ADDRESS, 2).toUpperCase();
    }

    public String getHashAddressTS2() {
        return this.getMessage().getHex(TIMESLOT_2_HASH_ADDRESS, 2).toUpperCase();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

