/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.dmr.channel.DmrRestLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola.CapacityPlusVoiceChannelUser;
import java.util.ArrayList;
import java.util.List;

public class CapacityPlusWideAreaVoiceChannelUser
extends CapacityPlusVoiceChannelUser
implements ITimeslotFrequencyReceiver {
    private static final int[] UNKNOWN_1 = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] GROUP_ID = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] UNUSED = new int[]{48, 49, 50};
    private static final int[] REST_LSN = new int[]{51, 52, 53, 54, 55};
    private static final int[] RADIO_ID = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private RadioIdentifier mRadio;
    private TalkgroupIdentifier mTalkgroup;
    private DmrRestLsn mRestChannel;
    private List<Identifier> mIdentifiers;

    public CapacityPlusWideAreaVoiceChannelUser(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        if (this.isEncrypted()) {
            sb.append(" *ENCRYPTED*");
        }
        if (this.isReservedBitSet()) {
            sb.append(" *RESERVED-BIT*");
        }
        sb.append("FLC MOTOROLA CAP+ WIDE-AREA VOICE CHANNEL USER FM:");
        sb.append(this.getRadio());
        sb.append(" TO:").append(this.getTalkgroup());
        if (this.hasRestChannel()) {
            sb.append(" ").append(this.getRestChannel());
        }
        sb.append(" ").append(this.getServiceOptions());
        sb.append(" UNK1:").append(this.getUnknown1());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public String getUnknown1() {
        return this.getMessage().getHex(UNKNOWN_1, 4);
    }

    public DmrRestLsn getRestChannel() {
        if (this.mRestChannel == null) {
            this.mRestChannel = new DmrRestLsn(this.getRestLSN());
        }
        return this.mRestChannel;
    }

    public int getRestLSN() {
        return this.getMessage().getInt(REST_LSN);
    }

    public boolean hasRestChannel() {
        return this.getRestLSN() != 0;
    }

    public RadioIdentifier getRadio() {
        if (this.mRadio == null) {
            this.mRadio = DMRRadio.createFrom(this.getMessage().getInt(RADIO_ID));
        }
        return this.mRadio;
    }

    public TalkgroupIdentifier getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = DMRTalkgroup.create(this.getMessage().getInt(GROUP_ID));
        }
        return this.mTalkgroup;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
            this.mIdentifiers.add(this.getRadio());
        }
        return this.mIdentifiers;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getRestChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getRestChannel().apply(timeslotFrequencies);
    }
}

