/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.AbstractVoiceChannelUser;
import java.util.ArrayList;
import java.util.List;

public class UnitToUnitVoiceChannelUser
extends AbstractVoiceChannelUser {
    private static final int[] TARGET_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SOURCE_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private RadioIdentifier mSourceRadio;
    private RadioIdentifier mTargetRadio;
    private List<Identifier> mIdentifiers;

    public UnitToUnitVoiceChannelUser(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("FLC UNIT TO UNIT VOICE CHANNEL USER FM:");
        sb.append(this.getSourceRadio());
        sb.append(" TO:").append(this.getTargetRadio());
        sb.append(" ").append(this.getServiceOptions());
        return sb.toString();
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceRadio;
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetRadio());
            this.mIdentifiers.add(this.getSourceRadio());
        }
        return this.mIdentifiers;
    }
}

