/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.dmr.message.data.header.DataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import io.github.dsheirer.module.decode.dmr.message.type.UnifiedDataTransportFormat;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;
import java.util.ArrayList;
import java.util.List;

public class UDTHeader
extends DataHeader {
    private static final int RADIO_TALKGROUP_FLAG = 0;
    private static final int[] SERVICE_ACCESS_POINT = new int[]{8, 9, 10, 11};
    private static final int[] UDT_FORMAT = new int[]{3, 12, 13, 14, 15};
    private static final int[] DESTINATION_IDENTIFIER = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SOURCE_RADIO = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] PAD_NIBBLE = new int[]{64, 65, 66, 67, 68};
    private static final int[] UAB = new int[]{70, 71};
    private static final int SUPPLEMENTARY_DATA_FLAG = 72;
    private static final int PROTECT_FLAG = 73;
    private static final int[] OPCODE = new int[]{74, 75, 76, 77, 78, 79};
    private IntegerIdentifier mDestinationLLID;
    private RadioIdentifier mSourceLLID;
    private List<Identifier> mIdentifiers;

    public UDTHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" UDT HEADER");
        if (this.isShortData()) {
            sb.append(" SHORT DATA");
        } else {
            sb.append(" SUPPLEMENTARY DATA");
        }
        sb.append(" FM:").append(this.getSourceLLID());
        sb.append(" TO:").append(this.getDestinationLLID());
        sb.append(" FORMAT:").append((Object)this.getFormat());
        Opcode opcode = this.getOpcode();
        if (opcode == Opcode.UNKNOWN) {
            sb.append(" OPCODE:").append(this.getOpcodeValue());
        } else {
            sb.append(" OPCODE:").append((Object)this.getOpcode());
        }
        sb.append(" PAD NIBBLES:").append(this.getPadNibbleCount());
        sb.append(" SAP:").append((Object)this.getServiceAccessPoint());
        return sb.toString();
    }

    public static boolean isSupplementaryData(CorrectedBinaryMessage message) {
        return message.get(72);
    }

    public boolean isShortData() {
        return !this.isSupplementaryData();
    }

    public boolean isSupplementaryData() {
        return UDTHeader.isSupplementaryData(this.getMessage());
    }

    public int getPadNibbleCount() {
        return this.getMessage().getInt(PAD_NIBBLE);
    }

    public static Opcode getOpcode(CorrectedBinaryMessage message) {
        return Opcode.fromValue(message.getInt(OPCODE), Vendor.STANDARD);
    }

    public int getOpcodeValue() {
        return this.getMessage().getInt(OPCODE);
    }

    public Opcode getOpcode() {
        return UDTHeader.getOpcode(this.getMessage());
    }

    public UnifiedDataTransportFormat getFormat() {
        return UnifiedDataTransportFormat.fromValue(this.getMessage().getInt(UDT_FORMAT));
    }

    public static ServiceAccessPoint getServiceAccessPoint(CorrectedBinaryMessage message) {
        return ServiceAccessPoint.fromValue(message.getInt(SERVICE_ACCESS_POINT));
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return UDTHeader.getServiceAccessPoint(this.getMessage());
    }

    public IntegerIdentifier getDestinationLLID() {
        if (this.mDestinationLLID == null) {
            this.mDestinationLLID = this.getMessage().get(0) ? DMRTalkgroup.create(this.getMessage().getInt(DESTINATION_IDENTIFIER)) : DMRRadio.createTo(this.getMessage().getInt(DESTINATION_IDENTIFIER));
        }
        return this.mDestinationLLID;
    }

    public RadioIdentifier getSourceLLID() {
        if (this.mSourceLLID == null) {
            this.mSourceLLID = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_RADIO));
        }
        return this.mSourceLLID;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDestinationLLID());
            this.mIdentifiers.add(this.getSourceLLID());
        }
        return this.mIdentifiers;
    }
}

