/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DMRUnitStatus;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.DataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import java.util.ArrayList;
import java.util.List;

public class StatusDataHeader
extends DataHeader {
    private static final int RADIO_TALKGROUP_FLAG = 0;
    private static final int[] SERVICE_ACCESS_POINT = new int[]{8, 9, 10, 11};
    private static final int[] APPENDED_BLOCKS = new int[]{2, 3, 12, 13, 14, 15};
    private static final int[] DESTINATION_IDENTIFIER = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SOURCE_RADIO = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SOURCE_PORT = new int[]{64, 65, 66};
    private static final int[] DESTINATION_PORT = new int[]{67, 68, 69};
    private static final int[] STATUS = new int[]{70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DMRUnitStatus mUnitStatus;
    private IntegerIdentifier mDestinationLLID;
    private RadioIdentifier mSourceLLID;
    private List<Identifier> mIdentifiers;

    public StatusDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" STATUS:").append(this.getUnitStatus());
        sb.append(" FM:").append(this.getSourceLLID());
        sb.append(" TO:").append(this.getDestinationLLID());
        sb.append(" ").append((Object)this.getServiceAccessPoint());
        sb.append(" SOURCE PORT:").append(this.getSourcePort());
        sb.append(" DESTINATION PORT:").append(this.getDestinationPort());
        return sb.toString();
    }

    public int getSourcePort() {
        return this.getMessage().getInt(SOURCE_PORT);
    }

    public int getDestinationPort() {
        return this.getMessage().getInt(DESTINATION_PORT);
    }

    public static int getAppendedBlocks(CorrectedBinaryMessage message) {
        return message.getInt(APPENDED_BLOCKS);
    }

    public int getAppendedBlocks() {
        return StatusDataHeader.getAppendedBlocks(this.getMessage());
    }

    public static ServiceAccessPoint getServiceAccessPoint(CorrectedBinaryMessage message) {
        return ServiceAccessPoint.fromValue(message.getInt(SERVICE_ACCESS_POINT));
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return StatusDataHeader.getServiceAccessPoint(this.getMessage());
    }

    public IntegerIdentifier getDestinationLLID() {
        if (this.mDestinationLLID == null) {
            this.mDestinationLLID = this.getMessage().get(0) ? DMRTalkgroup.create(this.getMessage().getInt(DESTINATION_IDENTIFIER)) : DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION_IDENTIFIER));
        }
        return this.mDestinationLLID;
    }

    public RadioIdentifier getSourceLLID() {
        if (this.mSourceLLID == null) {
            this.mSourceLLID = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE_RADIO));
        }
        return this.mSourceLLID;
    }

    public DMRUnitStatus getUnitStatus() {
        if (this.mUnitStatus == null) {
            this.mUnitStatus = DMRUnitStatus.create(this.getMessage().getInt(STATUS));
        }
        return this.mUnitStatus;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDestinationLLID());
            this.mIdentifiers.add(this.getSourceLLID());
            this.mIdentifiers.add(this.getUnitStatus());
        }
        return this.mIdentifiers;
    }
}

