/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.HeaderMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessageFactory;

public class PiHeader
extends HeaderMessage {
    public PiHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public LCMessage getLCMessage() {
        if (this.mLCMessage == null) {
            this.mLCMessage = LCMessageFactory.createFullEncryption(this.getMessage(), this.getTimestamp(), this.getTimeslot());
        }
        return this.mLCMessage;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(this.getSlotType());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits()).append(" ");
        }
        sb.append(" ").append(this.getLCMessage());
        return sb.toString();
    }
}

