/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.HeaderMessage;
import io.github.dsheirer.module.decode.dmr.message.type.DataPacketFormat;

public class DataHeader
extends HeaderMessage {
    private static final int[] DATA_PACKET_FORMAT = new int[]{4, 5, 6, 7};

    public DataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" DATA HEADER");
        sb.append(" FORMAT:").append((Object)this.getDataPacketFormat());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public static DataPacketFormat getDataPacketFormat(CorrectedBinaryMessage message) {
        return DataPacketFormat.fromValue(message.getInt(DATA_PACKET_FORMAT));
    }

    public DataPacketFormat getDataPacketFormat() {
        return DataHeader.getDataPacketFormat(this.getMessage());
    }

    public boolean isConfirmedData() {
        return this.getDataPacketFormat() == DataPacketFormat.CONFIRMED_DATA_PACKET;
    }

    public boolean isUnconfirmedData() {
        return this.getDataPacketFormat() == DataPacketFormat.UNCONFIRMED_DATA_PACKET;
    }
}

