/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.ArrayList;
import java.util.List;

public class AnnounceChannelFrequency
extends Announcement {
    private AbsoluteChannelParameters mAbsoluteChannelParameters;
    private List<Identifier> mIdentifiers;

    public AnnounceChannelFrequency(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
        if (multiBlock != null) {
            this.mAbsoluteChannelParameters = new AbsoluteChannelParameters(multiBlock.getMessage(), 0, 1);
        }
    }

    @Override
    public void checkCRC() {
        if (this.getSlotType().getDataType() == DataType.MBC_HEADER) {
            this.checkMultiBlockCRC(this.getAbsoluteChannelParameters());
        } else {
            super.checkCRC();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" ANNOUNCE CHANNEL");
        if (this.hasAbsoluteChannelParameters()) {
            sb.append(this.getAbsoluteChannelParameters().getChannel());
            sb.append(" CC:").append(this.getAbsoluteChannelParameters().getColorCode());
        }
        return sb.toString();
    }

    public AbsoluteChannelParameters getAbsoluteChannelParameters() {
        return this.mAbsoluteChannelParameters;
    }

    public boolean hasAbsoluteChannelParameters() {
        return this.getAbsoluteChannelParameters() != null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasAbsoluteChannelParameters()) {
                this.mIdentifiers.add(this.getAbsoluteChannelParameters().getChannel());
            }
        }
        return this.mIdentifiers;
    }
}

