/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRUnitStatus;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge.Acknowledge;
import java.util.ArrayList;
import java.util.List;

public class AcknowledgeStatus
extends Acknowledge {
    private DMRUnitStatus mUnitStatus;

    public AcknowledgeStatus(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public DMRUnitStatus getUnitStatus() {
        if (this.mUnitStatus == null) {
            this.mUnitStatus = DMRUnitStatus.create(this.getMessage().getInt(RESPONSE_INFO));
        }
        return this.mUnitStatus;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" ACKNOWLEDGE STATUS:").append(this.getUnitStatus());
        sb.append(" TO:").append(this.getTargetAddress());
        if (this.hasSourceRadio()) {
            sb.append(" FM:").append(this.getSourceRadio());
        }
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList();
            this.mIdentifiers.add(this.getTargetAddress());
            if (this.hasSourceRadio()) {
                this.mIdentifiers.add(this.getSourceRadio());
            }
            this.mIdentifiers.add(this.getUnitStatus());
        }
        return this.mIdentifiers;
    }
}

