/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRTier3Channel;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.ArrayList;
import java.util.List;

public class Clear
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] CHANNEL_NUMBER = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    private static final int TALKGROUP_FLAG = 31;
    protected static final int[] DESTINATION = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    protected static final int[] SOURCE = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DMRChannel mChannel;
    private AbsoluteChannelParameters mAbsoluteChannelParameters;
    private RadioIdentifier mSourceRadio;
    private IntegerIdentifier mDestinationId;
    private List<Identifier> mIdentifiers;

    public Clear(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public Clear(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        this(syncPattern, message, cach, slotType, timestamp, timeslot);
        if (multiBlock != null) {
            this.mAbsoluteChannelParameters = new AbsoluteChannelParameters(multiBlock.getMessage(), 0, this.getMoveToTimeslot());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        sb.append(" CLEAR - RETURN TO").append(this.getMoveToChannel());
        sb.append(" FM:").append(this.getSourceRadio());
        sb.append(" TO:").append(this.getDestinationId());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    @Override
    public void checkCRC() {
        if (this.getSlotType().getDataType() == DataType.MBC_HEADER) {
            this.checkMultiBlockCRC(this.getAbsoluteChannelParameters());
        } else {
            super.checkCRC();
        }
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE));
        }
        return this.mSourceRadio;
    }

    public IntegerIdentifier getDestinationId() {
        if (this.mDestinationId == null) {
            this.mDestinationId = this.getMessage().get(31) ? DMRTalkgroup.create(this.getMessage().getInt(DESTINATION)) : DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION));
        }
        return this.mDestinationId;
    }

    private int getMoveToTimeslot() {
        return 1;
    }

    private int getMoveToChannelNumber() {
        return this.getMessage().getInt(CHANNEL_NUMBER);
    }

    public AbsoluteChannelParameters getAbsoluteChannelParameters() {
        return this.mAbsoluteChannelParameters;
    }

    public boolean hasAbsoluteChannelParameters() {
        return this.getAbsoluteChannelParameters() != null;
    }

    public DMRChannel getMoveToChannel() {
        if (this.hasAbsoluteChannelParameters()) {
            return this.mAbsoluteChannelParameters.getChannel();
        }
        if (this.mChannel == null) {
            this.mChannel = new DMRTier3Channel(this.getMoveToChannelNumber(), this.getMoveToTimeslot());
        }
        return this.mChannel;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        if (this.getMoveToChannel() != null) {
            return this.getMoveToChannel().getLogicalChannelNumbers();
        }
        return new int[0];
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        if (this.getMoveToChannel() != null) {
            this.getMoveToChannel().apply(timeslotFrequencies);
        }
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getMoveToChannel());
            this.mIdentifiers.add(this.getSourceRadio());
            this.mIdentifiers.add(this.getDestinationId());
        }
        return this.mIdentifiers;
    }
}

