/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import com.google.common.base.Joiner;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.site.SiteIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusNeighborReport
extends CSBKMessage {
    private static final int SITE_ARRAY_START = 16;
    private static final int[] UNKNOWN = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<SiteIdentifier> mNeighbors;
    private List<Identifier> mIdentifiers;

    public ConnectPlusNeighborReport(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CON+ NEIGHBORS:");
        List<SiteIdentifier> neighbors = this.getNeighbors();
        if (neighbors.isEmpty()) {
            sb.append("NONE");
        } else {
            sb.append(Joiner.on((String)",").join(this.getNeighbors()));
        }
        sb.append(" UNK:").append(this.getUnknownField());
        return sb.toString();
    }

    public String getUnknownField() {
        return this.getMessage().getHex(UNKNOWN, 6);
    }

    public List<SiteIdentifier> getNeighbors() {
        if (this.mNeighbors == null) {
            this.mNeighbors = new ArrayList<SiteIdentifier>();
            for (int x = 0; x <= 5; ++x) {
                int site = this.getSite(x);
                if (site <= 0) continue;
                this.mNeighbors.add(DMRSite.create(site));
            }
        }
        return this.mNeighbors;
    }

    private int getSite(int index) {
        int start = 16 + index * 8;
        int end = start + 7;
        return this.getMessage().getInt(start, end);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.addAll(this.getNeighbors());
        }
        return this.mIdentifiers;
    }
}

