/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class CapacityPlusDataRevertWindowAnnouncement
extends CSBKMessage {
    private static final int[] RESERVED = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] TARGET_RADIO = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] WINDOW = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SUPER_FRAME = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] UNKNOWN_1 = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] UNKNOWN_2 = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private RadioIdentifier mTargetRadio;
    private List<Identifier> mIdentifiers;

    public CapacityPlusDataRevertWindowAnnouncement(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CAP+ ENHANCED DATA REVERT ANNOUNCEMENT");
        sb.append(" WINDOW:").append(this.getSuperFrame()).append(".").append(this.getWindow());
        if (this.hasTargetRadio()) {
            sb.append(" RESERVED FOR RADIO:").append(this.getTargetRadio());
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean hasTargetRadio() {
        return this.getMessage().getInt(TARGET_RADIO) > 0;
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null && this.hasTargetRadio()) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_RADIO));
        }
        return this.mTargetRadio;
    }

    public int getSuperFrame() {
        return this.getMessage().getInt(SUPER_FRAME);
    }

    public int getWindow() {
        return this.getMessage().getInt(WINDOW);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasTargetRadio()) {
                this.mIdentifiers.add(this.getTargetRadio());
            }
        }
        return this.mIdentifiers;
    }
}

