/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.AnnouncementType;
import io.github.dsheirer.module.decode.dmr.message.type.SystemIdentityCode;
import java.util.ArrayList;
import java.util.List;

public class HyteraAnnouncement
extends CSBKMessage {
    private static final int[] ANNOUNCEMENT_TYPE = new int[]{16, 17, 18, 19, 20};
    private static final int PARAMS_1_START = 21;
    private static final int PARAMS_1_END = 35;
    private static final int[] PARAMS_1 = new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34};
    private static final int REGISTRATION_REQUIRED_FLAG = 35;
    private static final int[] BACKOFF = new int[]{36, 37, 38, 39};
    private static final int SYSTEM_IDENTITY_CODE_OFFSET = 40;
    private static final int PARAMS_2_START = 56;
    private static final int PARAMS_2_END = 80;
    private static final int[] PARAMS_2 = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private SystemIdentityCode mSystemIdentityCode;

    public HyteraAnnouncement(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" HYTERA ANNOUNCEMENT-TYPE:").append((Object)this.getAnnouncementType());
        sb.append(" ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        sb.append(" P1:").append(this.getParams1().toHexString());
        sb.append(" P2:").append(this.getParams2().toHexString());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public BinaryMessage getParams1() {
        return this.getMessage().getSubMessage(21, 35);
    }

    public BinaryMessage getParams2() {
        return this.getMessage().getSubMessage(56, 80);
    }

    public boolean isRegistrationRequired() {
        return this.getMessage().get(35);
    }

    public int getBackoff() {
        return this.getMessage().getInt(BACKOFF);
    }

    public SystemIdentityCode getSystemIdentityCode() {
        if (this.mSystemIdentityCode == null) {
            this.mSystemIdentityCode = new SystemIdentityCode(this.getMessage(), 40, true);
        }
        return this.mSystemIdentityCode;
    }

    public AnnouncementType getAnnouncementType() {
        return HyteraAnnouncement.getAnnouncementType(this.getMessage());
    }

    public static AnnouncementType getAnnouncementType(CorrectedBinaryMessage message) {
        return AnnouncementType.fromValue(message.getInt(ANNOUNCEMENT_TYPE));
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
        }
        return this.mIdentifiers;
    }
}

