/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceFunction;
import io.github.dsheirer.module.decode.dmr.message.type.SystemIdentityCode;
import io.github.dsheirer.module.decode.dmr.message.type.Version;
import java.util.ArrayList;
import java.util.List;

public class HyteraAloha
extends CSBKMessage {
    private static final int[] RESERVED = new int[]{16, 17};
    private static final int SITE_TIMESLOT_SYNCHRONIZATION = 18;
    private static final int[] VERSION = new int[]{19, 20, 21};
    private static final int TIMING_OFFSET = 22;
    private static final int ACTIVE_NETWORK_CONNECTION_FLAG = 23;
    private static final int[] MASK = new int[]{24, 25, 26, 27, 28};
    private static final int[] SERVICE_FUNCTION = new int[]{29, 30};
    private static final int[] N_RAND_WAIT = new int[]{31, 32, 33, 34};
    private static final int REGISTRATION_REQUIRED_FLAG = 35;
    private static final int[] BACKOFF = new int[]{36, 37, 38, 39};
    private static final int SYSTEM_IDENTITY_CODE_OFFSET = 40;
    private static final int[] RADIO = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private SystemIdentityCode mSystemIdentityCode;
    private RadioIdentifier mRadioIdentifier;
    private List<Identifier> mIdentifiers;

    public HyteraAloha(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" HYTERA ALOHA");
        if (this.hasRadioIdentifier()) {
            sb.append(" TO:").append(this.getRadioIdentifier());
        }
        sb.append(" ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        if (this.hasActiveNetworkConnection()) {
            sb.append(" NET-CONNECTED");
        } else {
            sb.append(" NET-DISCONNECTED");
        }
        sb.append(" SERVICES:").append((Object)this.getServiceFunction());
        sb.append(" ETSI VER:").append((Object)this.getVersion());
        sb.append(" MASK:").append(this.getMask());
        if (this.getSystemIdentityCode().getPAR().isMultipleControlChannels()) {
            sb.append(" ").append((Object)this.getSystemIdentityCode().getPAR());
        }
        sb.append(" ").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public ServiceFunction getServiceFunction() {
        return ServiceFunction.fromValue(this.getMessage().getInt(SERVICE_FUNCTION));
    }

    public int getMask() {
        return this.getMessage().getInt(MASK);
    }

    public boolean hasActiveNetworkConnection() {
        return this.getMessage().get(23);
    }

    public Version getVersion() {
        return Version.fromValue(this.getMessage().getInt(VERSION));
    }

    public RadioIdentifier getRadioIdentifier() {
        if (this.mRadioIdentifier == null) {
            this.mRadioIdentifier = DmrTier3Radio.createTo(this.getMessage().getInt(RADIO));
        }
        return this.mRadioIdentifier;
    }

    public boolean hasRadioIdentifier() {
        return this.getMessage().getInt(RADIO) != 0;
    }

    public SystemIdentityCode getSystemIdentityCode() {
        if (this.mSystemIdentityCode == null) {
            this.mSystemIdentityCode = new SystemIdentityCode(this.getMessage(), 40, true);
        }
        return this.mSystemIdentityCode;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasRadioIdentifier()) {
                this.mIdentifiers.add(this.getRadioIdentifier());
            }
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }
}

