/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.block;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock;

public class DataBlock3_4Rate
extends DataBlock {
    private static final int[] CRC = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int CONFIRMED_PAYLOAD_START = 16;
    private static final int UNCONFIRMED_PAYLOAD_START = 0;
    private static final int PAYLOAD_END = 144;

    public DataBlock3_4Rate(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" RATE 3/4 DATA CONFIRMED:").append(this.getConfirmedPayload().toHexString());
        sb.append(" UNCONFIRMED:").append(this.getUnConfirmedPayload().toHexString());
        return sb.toString();
    }

    @Override
    public CorrectedBinaryMessage getConfirmedPayload() {
        return this.getMessage().getSubMessage(16, 144);
    }

    @Override
    public CorrectedBinaryMessage getUnConfirmedPayload() {
        return this.getMessage().getSubMessage(0, 144);
    }
}

