/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.Collections;
import java.util.List;

public abstract class DataMessageWithLinkControl
extends DataMessage {
    protected LCMessage mLCMessage;

    public DataMessageWithLinkControl(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public LCMessage getLCMessage() {
        if (this.mLCMessage == null) {
            boolean isTerminator = this.getSlotType().getDataType() == DataType.TLC;
            this.mLCMessage = LCMessageFactory.createFull(this.getMessage(), this.getTimestamp(), this.getTimeslot(), isTerminator);
        }
        return this.mLCMessage;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasRAS()) {
            sb.append("RAS:").append(this.getBPTCReservedBits()).append(" ");
        }
        sb.append(this.getSlotType());
        sb.append(" ").append(this.getLCMessage());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.getLCMessage() != null) {
            return this.getLCMessage().getIdentifiers();
        }
        return Collections.emptyList();
    }
}

