/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.identifier;

import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.protocol.Protocol;

public class DMRTalkgroup
extends TalkgroupIdentifier {
    private boolean mCompressed = false;
    private int mOriginalValue;

    public DMRTalkgroup(int value) {
        super(value, Role.TO);
        this.mOriginalValue = value;
    }

    public DMRTalkgroup(int value, Role role) {
        super(value, role);
        this.mOriginalValue = value;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.DMR;
    }

    @Override
    public String toString() {
        if (this.mCompressed) {
            return super.toString() + "(c)";
        }
        return super.toString();
    }

    public void setCompressed(boolean compressed) {
        this.mCompressed = compressed;
        if (this.mCompressed) {
            this.setValue(DMRTalkgroup.getCompressed(this.mOriginalValue));
        } else {
            this.setValue(this.mOriginalValue);
        }
    }

    public static int getCompressed(int original) {
        int converted = 0;
        int units = original / 1464100;
        converted += units * 1000000;
        original -= units * 1464100;
        units = original / 146410;
        converted += units * 100000;
        original -= units * 146410;
        units = original / 14641;
        converted += units * 10000;
        original -= units * 14641;
        units = original / 1331;
        converted += units * 1000;
        original -= units * 1331;
        units = original / 121;
        converted += units * 100;
        original -= units * 121;
        units = original / 11;
        converted += units * 10;
        return converted += (original -= units * 11);
    }

    public static TalkgroupIdentifier create(int talkgroup) {
        return new DMRTalkgroup(talkgroup);
    }

    public static TalkgroupIdentifier createAny(int talkgroup) {
        return new DMRTalkgroup(talkgroup, Role.ANY);
    }
}

