/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.audio;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.codec.mbe.AmbeAudioModule;
import io.github.dsheirer.audio.squelch.SquelchState;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.IdentifierUpdateProvider;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.tone.AmbeTone;
import io.github.dsheirer.identifier.tone.Tone;
import io.github.dsheirer.identifier.tone.ToneIdentifier;
import io.github.dsheirer.identifier.tone.ToneIdentifierMessage;
import io.github.dsheirer.identifier.tone.ToneSequence;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageProvider;
import io.github.dsheirer.module.decode.dmr.identifier.DMRToneIdentifier;
import io.github.dsheirer.module.decode.dmr.message.data.header.VoiceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.AbstractVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.terminator.Terminator;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceEMBMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jmbe.iface.IAudioWithMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRAudioModule
extends AmbeAudioModule
implements IdentifierUpdateProvider,
IMessageProvider {
    private static final Logger mLog = LoggerFactory.getLogger(DMRAudioModule.class);
    private SquelchStateListener mSquelchStateListener = new SquelchStateListener();
    private ToneMetadataProcessor mToneMetadataProcessor = new ToneMetadataProcessor(this);
    private Listener<IdentifierUpdateNotification> mIdentifierUpdateNotificationListener;
    private List<byte[]> mQueuedAmbeFrames = new ArrayList<byte[]>();
    private boolean mEncryptedCallStateEstablished = false;
    private boolean mEncryptedCall = false;
    private Listener<IMessage> mMessageListener;

    public DMRAudioModule(UserPreferences userPreferences, AliasList aliasList, int timeslot) {
        super(userPreferences, aliasList, timeslot);
    }

    @Override
    public Listener<SquelchStateEvent> getSquelchStateListener() {
        return this.mSquelchStateListener;
    }

    @Override
    public void reset() {
        this.mIdentifierCollection.remove(Role.FROM);
        this.mEncryptedCall = false;
        this.mEncryptedCallStateEstablished = false;
        this.mQueuedAmbeFrames.clear();
    }

    @Override
    public void start() {
    }

    @Override
    public void receive(IMessage message) {
        if (this.hasAudioCodec() && message.getTimeslot() == this.getTimeslot()) {
            if (!this.mEncryptedCallStateEstablished) {
                VoiceEMBMessage voiceMessage;
                VoiceMessage vm;
                if (message instanceof VoiceMessage && (vm = (VoiceMessage)message).getSyncPattern().isDirectMode()) {
                    this.mEncryptedCallStateEstablished = true;
                    this.mEncryptedCall = false;
                } else if (message instanceof VoiceEMBMessage && (voiceMessage = (VoiceEMBMessage)message).getEMB().isValid()) {
                    this.mEncryptedCallStateEstablished = true;
                    this.mEncryptedCall = voiceMessage.getEMB().isEncrypted();
                } else if (message instanceof VoiceHeader) {
                    FullLCMessage flc;
                    VoiceHeader voiceHeader = (VoiceHeader)message;
                    LCMessage lc = voiceHeader.getLCMessage();
                    if (lc instanceof FullLCMessage && (flc = (FullLCMessage)lc).isValid()) {
                        this.mEncryptedCallStateEstablished = true;
                        this.mEncryptedCall = flc.isEncrypted();
                    }
                } else if (message instanceof AbstractVoiceChannelUser) {
                    AbstractVoiceChannelUser avcu = (AbstractVoiceChannelUser)message;
                    this.mEncryptedCallStateEstablished = true;
                    this.mEncryptedCall = avcu.getServiceOptions().isEncrypted();
                }
            }
            if (message instanceof VoiceMessage) {
                VoiceMessage voiceMessage = (VoiceMessage)message;
                List<byte[]> frames = voiceMessage.getAMBEFrames();
                for (byte[] frame : frames) {
                    this.processAudio(frame, message.getTimestamp());
                }
            } else if (message instanceof Terminator) {
                this.reset();
            }
        }
    }

    private void processAudio(byte[] frame, long timestamp) {
        if (this.mEncryptedCallStateEstablished) {
            if (!this.mQueuedAmbeFrames.isEmpty()) {
                if (!this.mEncryptedCall) {
                    for (byte[] queuedFrame : this.mQueuedAmbeFrames) {
                        this.produceAudio(queuedFrame, timestamp);
                    }
                    this.mQueuedAmbeFrames.clear();
                }
                this.mQueuedAmbeFrames.clear();
            }
            this.produceAudio(frame, timestamp);
        } else {
            this.mQueuedAmbeFrames.add(frame);
        }
    }

    private void produceAudio(byte[] frame, long timestamp) {
        try {
            IAudioWithMetadata audioWithMetadata = this.getAudioCodec().getAudioWithMetadata(frame);
            this.addAudio(audioWithMetadata.getAudio());
            this.processMetadata(audioWithMetadata, timestamp);
        }
        catch (Exception e) {
            mLog.error("Error synthesizing DMR AMBE audio - continuing [" + e.getMessage() + "]");
        }
    }

    private void processMetadata(IAudioWithMetadata audioWithMetadata, long timestamp) {
        if (audioWithMetadata.hasMetadata()) {
            for (Map.Entry entry : audioWithMetadata.getMetadata().entrySet()) {
                ToneIdentifier metadataIdentifier = this.mToneMetadataProcessor.process((String)entry.getKey(), (String)entry.getValue());
                if (metadataIdentifier == null) continue;
                this.broadcast(metadataIdentifier, timestamp);
            }
        } else {
            this.mToneMetadataProcessor.closeMetadata();
        }
    }

    private void broadcast(ToneIdentifier identifier, long timestamp) {
        if (this.mIdentifierUpdateNotificationListener != null) {
            this.mIdentifierUpdateNotificationListener.receive(new IdentifierUpdateNotification(identifier, IdentifierUpdateNotification.Operation.ADD, this.getTimeslot()));
        }
        if (this.mMessageListener != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("DMR Timeslot ");
            sb.append(this.getTimeslot());
            sb.append("Audio Tone Sequence Decoded: ");
            sb.append(identifier.toString());
            this.mMessageListener.receive(new ToneIdentifierMessage(Protocol.DMR, this.getTimeslot(), timestamp, identifier, sb.toString()));
        }
    }

    @Override
    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateNotificationListener = listener;
    }

    @Override
    public void removeIdentifierUpdateListener() {
        this.mIdentifierUpdateNotificationListener = null;
    }

    @Override
    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    @Override
    public void removeMessageListener() {
        this.mMessageListener = null;
    }

    public class SquelchStateListener
    implements Listener<SquelchStateEvent> {
        @Override
        public void receive(SquelchStateEvent event) {
            if (event.getTimeslot() == DMRAudioModule.this.getTimeslot() && event.getSquelchState() == SquelchState.SQUELCH) {
                DMRAudioModule.this.closeAudioSegment();
            }
        }
    }

    public class ToneMetadataProcessor {
        private List<Tone> mTones = new ArrayList<Tone>();
        private Tone mCurrentTone;

        public ToneMetadataProcessor(DMRAudioModule this$0) {
        }

        public void reset() {
            this.mTones.clear();
        }

        public ToneIdentifier process(String type, String value) {
            if (type == null || value == null) {
                return null;
            }
            AmbeTone tone = AmbeTone.fromValues(type, value);
            if (tone == AmbeTone.INVALID) {
                return null;
            }
            if (this.mCurrentTone == null || this.mCurrentTone.getAmbeTone() != tone) {
                this.mCurrentTone = new Tone(tone);
                this.mTones.add(this.mCurrentTone);
            }
            this.mCurrentTone.incrementDuration();
            return DMRToneIdentifier.create(new ToneSequence(new ArrayList<Tone>(this.mTones)));
        }

        public void closeMetadata() {
            this.mCurrentTone = null;
        }
    }
}

