/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.QPSKCarrierLock;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import org.apache.commons.lang3.Validate;

public class DMRSyncDetector {
    private static long SYNC_MASK = 0xFFFFFFFFFFFFL;
    private static final int MAX_PATTERN_BIT_ERROR_PLL_MISALIGNMENT = 1;
    private int mMaxStreamBitErrors;
    private int mMaxExplicitBitErrors;
    private long mCurrentSyncValue;
    private long mErrorPattern;
    private int mPatternMatchBitErrorCount;
    private DMRSyncPattern mSyncPattern = DMRSyncPattern.UNKNOWN;
    private QPSKCarrierLock mCarrierLock = QPSKCarrierLock.NORMAL;

    public DMRSyncDetector(int maxStreamBitErrors, int maxExplicitBitErrors) {
        Validate.inclusiveBetween((long)0L, (long)24L, (long)maxStreamBitErrors, (String)"Max (allowable) stream bit errors for sync match must be between 0 and 24");
        Validate.inclusiveBetween((long)0L, (long)24L, (long)maxExplicitBitErrors, (String)"Max (allowable) explicit bit errors for sync match must be between 0 and 24");
        this.mMaxStreamBitErrors = maxStreamBitErrors;
        this.mMaxExplicitBitErrors = maxExplicitBitErrors;
    }

    public DMRSyncPattern getSyncPattern() {
        return this.mSyncPattern;
    }

    public boolean hasSync() {
        return this.getSyncPattern() != DMRSyncPattern.UNKNOWN;
    }

    public QPSKCarrierLock getCarrierLock() {
        return this.mCarrierLock;
    }

    public boolean hasNormalCarrierLock() {
        return this.getCarrierLock() == QPSKCarrierLock.NORMAL;
    }

    public int getPatternMatchBitErrorCount() {
        return this.mPatternMatchBitErrorCount;
    }

    public void add(Dibit dibit) {
        this.mCurrentSyncValue = Long.rotateLeft(this.mCurrentSyncValue, 2);
        this.mCurrentSyncValue &= SYNC_MASK;
        this.mCurrentSyncValue += (long)dibit.getValue();
        this.checkSync(this.mMaxStreamBitErrors);
    }

    public void setCurrentSyncValue(long value) {
        this.mCurrentSyncValue = value;
        this.checkSync(this.mMaxExplicitBitErrors);
    }

    private void checkSync(int maxBitErrors) {
        for (DMRSyncPattern pattern : DMRSyncPattern.SYNC_PATTERNS) {
            this.mErrorPattern = this.mCurrentSyncValue ^ pattern.getPattern();
            if (this.mErrorPattern == 0L) {
                this.mSyncPattern = pattern;
                this.mCarrierLock = QPSKCarrierLock.NORMAL;
                this.mPatternMatchBitErrorCount = 0;
                return;
            }
            this.mPatternMatchBitErrorCount = Long.bitCount(this.mErrorPattern);
            if (this.mPatternMatchBitErrorCount <= maxBitErrors) {
                this.mSyncPattern = pattern;
                this.mCarrierLock = QPSKCarrierLock.NORMAL;
                return;
            }
            this.mPatternMatchBitErrorCount = Long.bitCount(this.mCurrentSyncValue ^ pattern.getPlus90Pattern());
            if (this.mPatternMatchBitErrorCount <= 1) {
                this.mSyncPattern = pattern;
                this.mCarrierLock = QPSKCarrierLock.PLUS_90;
                return;
            }
            this.mPatternMatchBitErrorCount = Long.bitCount(this.mCurrentSyncValue ^ pattern.getMinus90Pattern());
            if (this.mPatternMatchBitErrorCount <= 1) {
                this.mSyncPattern = pattern;
                this.mCarrierLock = QPSKCarrierLock.MINUS_90;
                return;
            }
            this.mPatternMatchBitErrorCount = Long.bitCount(this.mCurrentSyncValue ^ pattern.getInvertedPattern());
            if (this.mPatternMatchBitErrorCount > 1) continue;
            this.mSyncPattern = pattern;
            this.mCarrierLock = QPSKCarrierLock.INVERTED;
            return;
        }
        this.mSyncPattern = DMRSyncPattern.UNKNOWN;
        this.mCarrierLock = QPSKCarrierLock.NORMAL;
        this.mPatternMatchBitErrorCount = 0;
    }
}

