/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.dsp.psk.DQPSKDecisionDirectedDemodulatorInstrumented;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBufferInstrumented;
import io.github.dsheirer.dsp.psk.SymbolDecisionData;
import io.github.dsheirer.module.decode.dmr.DMRDecoder;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSamples;

public class DMRDecoderInstrumented
extends DMRDecoder {
    private Listener<Double> mPLLPhaseErrorListener;
    private Listener<Double> mPLLFrequencyListener;
    private Listener<Double> mSamplesPerSymbolListener;
    private Listener<Complex> mComplexSymbolListener;
    private Listener<ComplexSamples> mFilteredSymbolListener;
    private Listener<SymbolDecisionData> mSymbolDecisionDataListener;

    public DMRDecoderInstrumented(DecodeConfigDMR config) {
        super(config);
    }

    @Override
    public void receive(ComplexSamples samples) {
        this.mMessageFramer.setCurrentTime(samples.timestamp());
        float[] i = this.mIBasebandFilter.filter(samples.i());
        float[] q = this.mQBasebandFilter.filter(samples.q());
        if (this.mFilteredSymbolListener != null) {
            this.mFilteredSymbolListener.receive(new ComplexSamples(i, q, samples.timestamp()));
        }
        this.mPowerMonitor.process(i, q);
        ComplexSamples amplified = this.mAGC.process(i, q, samples.timestamp());
        this.mQPSKDemodulator.receive(amplified);
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        InterpolatingSampleBufferInstrumented instrumentedBuffer = new InterpolatingSampleBufferInstrumented(this.getSamplesPerSymbol(), 0.4f);
        this.mInterpolatingSampleBuffer = instrumentedBuffer;
        DQPSKDecisionDirectedDemodulatorInstrumented instrumented = new DQPSKDecisionDirectedDemodulatorInstrumented(this.mCostasLoop, instrumentedBuffer, this.getSampleRate());
        this.mQPSKDemodulator = instrumented;
        instrumented.setComplexSymbolListener(this.mComplexSymbolListener);
        instrumented.setPLLErrorListener(this.mPLLPhaseErrorListener);
        instrumented.setPLLFrequencyListener(this.mPLLFrequencyListener);
        instrumented.setSymbolDecisionDataListener(this.mSymbolDecisionDataListener);
        instrumented.setSamplesPerSymbolListener(this.mSamplesPerSymbolListener);
        instrumented.setSymbolListener(this.getDibitBroadcaster());
        this.getDibitBroadcaster().addListener(this.mMessageFramer);
    }

    public void setComplexSymbolListener(Listener<Complex> listener) {
        this.mComplexSymbolListener = listener;
        ((DQPSKDecisionDirectedDemodulatorInstrumented)this.mQPSKDemodulator).setComplexSymbolListener(listener);
    }

    public void setPLLPhaseErrorListener(Listener<Double> listener) {
        this.mPLLPhaseErrorListener = listener;
        ((DQPSKDecisionDirectedDemodulatorInstrumented)this.mQPSKDemodulator).setPLLErrorListener(listener);
    }

    public void setPLLFrequencyListener(Listener<Double> listener) {
        this.mPLLFrequencyListener = listener;
        ((DQPSKDecisionDirectedDemodulatorInstrumented)this.mQPSKDemodulator).setPLLFrequencyListener(listener);
    }

    public void setFilteredBufferListener(Listener<ComplexSamples> listener) {
        this.mFilteredSymbolListener = listener;
    }

    public void setSymbolDecisionDataListener(Listener<SymbolDecisionData> listener) {
        this.mSymbolDecisionDataListener = listener;
        ((DQPSKDecisionDirectedDemodulatorInstrumented)this.mQPSKDemodulator).setSymbolDecisionDataListener(listener);
    }

    public void setSamplesPerSymbolListener(Listener<Double> listener) {
        this.mSamplesPerSymbolListener = listener;
        ((DQPSKDecisionDirectedDemodulatorInstrumented)this.mQPSKDemodulator).setSamplesPerSymbolListener(listener);
    }
}

